/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.hglteam.conversion.api.ConversionKey;

public abstract class GenericConversionKey<TS, TD>
implements ConversionKey {
    private final Type source;
    private final Type target;

    public GenericConversionKey() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException();
        }
        ParameterizedType parameterizedClass = (ParameterizedType)superclass;
        this.source = parameterizedClass.getActualTypeArguments()[0];
        this.target = parameterizedClass.getActualTypeArguments()[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConversionKey)) {
            return false;
        }
        ConversionKey that = (ConversionKey)o;
        return ConversionKey.areEqual(this, that);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    @Override
    public Type getSource() {
        return this.source;
    }

    @Override
    public Type getTarget() {
        return this.target;
    }
}

