/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api.context;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.Converter;
import org.hglteam.conversion.api.DefaultConvertionKey;
import org.hglteam.conversion.api.context.TypeConversionContext;

public class ContextConversionBuilder<TD> {
    private Converter converter;
    private Type targetType;
    private Type sourceType;
    private ConversionKey conversionKey;
    private Object[] args;

    public ContextConversionBuilder(Converter converter, Type targetType) {
        this.converter = converter;
        this.targetType = targetType;
    }

    public ContextConversionBuilder<TD> withConvertionKey(ConversionKey conversionKey) {
        this.conversionKey = conversionKey;
        return this;
    }

    public ContextConversionBuilder<TD> withSourceType(Type sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public ContextConversionBuilder<TD> withTargetType(Type targetType) {
        this.targetType = targetType;
        return this;
    }

    public ContextConversionBuilder<TD> withArgs(Object ... args) {
        this.args = args;
        return this;
    }

    public <TS> TD convert(TS source) {
        this.sourceType = Optional.ofNullable(this.sourceType).orElse(source.getClass());
        Objects.requireNonNull(this.targetType);
        this.conversionKey = Optional.ofNullable(this.conversionKey).orElseGet(() -> ((DefaultConvertionKey.DefaultConvertionKeyBuilder)((DefaultConvertionKey.DefaultConvertionKeyBuilder)DefaultConvertionKey.builder().source(this.sourceType)).target(this.targetType)).build());
        return this.converter.convert(source, (TypeConversionContext)((TypeConversionContext.TypeConversionContextBuilder)((TypeConversionContext.TypeConversionContextBuilder)((TypeConversionContext.TypeConversionContextBuilder)TypeConversionContext.builder().converter(this.converter)).currentConversionKey(this.conversionKey)).arguments(this.args)).build());
    }

    public Converter getConverter() {
        return this.converter;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public ConversionKey getConversionKey() {
        return this.conversionKey;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

