/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.DefaultConvertionKey;
import org.hglteam.conversion.api.ExplicitTypeConverter;
import org.hglteam.conversion.api.context.TypeConversionContext;

public abstract class GenericTypeConverter<TS, TD>
implements ExplicitTypeConverter<TS, TD> {
    private final BiFunction<TypeConversionContext, TS, TD> conversionFunction;
    private final ConversionKey conversionKey;

    public GenericTypeConverter(BiFunction<TypeConversionContext, TS, TD> conversionFunction) {
        this.conversionFunction = conversionFunction;
        this.conversionKey = GenericTypeConverter.inferConversionKey(this.getClass());
    }

    public GenericTypeConverter(Function<TS, TD> conversionFunction) {
        this.conversionFunction = (context, ts) -> conversionFunction.apply(ts);
        this.conversionKey = GenericTypeConverter.inferConversionKey(this.getClass());
    }

    @Override
    public TD convert(TypeConversionContext context, TS source) {
        return this.conversionFunction.apply(context, source);
    }

    private static ConversionKey inferConversionKey(Class<?> aClass) {
        Type superclass = aClass.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parameterizedClass = (ParameterizedType)superclass;
            return ((DefaultConvertionKey.DefaultConvertionKeyBuilder)((DefaultConvertionKey.DefaultConvertionKeyBuilder)DefaultConvertionKey.builder().source(parameterizedClass.getActualTypeArguments()[0])).target(parameterizedClass.getActualTypeArguments()[1])).build();
        }
        throw new IllegalArgumentException();
    }

    public BiFunction<TypeConversionContext, TS, TD> getConversionFunction() {
        return this.conversionFunction;
    }

    @Override
    public ConversionKey getConversionKey() {
        return this.conversionKey;
    }
}

