/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api.context;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.Converter;
import org.hglteam.conversion.api.DefaultConvertionKey;
import org.hglteam.conversion.api.context.TypeConversionContext;

public class ContextualConversionBuilder<TD> {
    private Converter converter;
    private Type targetType;
    private Type sourceType;
    private ConversionKey conversionKey;
    private Object[] args;

    public ContextualConversionBuilder(Converter converter, Type targetType) {
        this.converter = converter;
        this.targetType = targetType;
    }

    public ContextualConversionBuilder(Converter converter, Class<? extends TD> targetClass) {
        this(converter, targetClass);
    }

    public ContextualConversionBuilder<TD> withConvertionKey(ConversionKey conversionKey) {
        this.conversionKey = conversionKey;
        return this;
    }

    public ContextualConversionBuilder<TD> withSourceType(Type sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public ContextualConversionBuilder<TD> withTargetType(Type targetType) {
        this.targetType = targetType;
        return this;
    }

    public ContextualConversionBuilder<TD> withArgs(Object ... args) {
        this.args = args;
        return this;
    }

    public <TS> TD convert(TS source) {
        ConversionKey conversionKey = Optional.ofNullable(this.conversionKey).orElseGet(() -> ((DefaultConvertionKey.DefaultConvertionKeyBuilder)((DefaultConvertionKey.DefaultConvertionKeyBuilder)DefaultConvertionKey.builder().source(Objects.nonNull(this.sourceType) ? this.sourceType : source.getClass())).target(this.targetType)).build());
        Object context = ((TypeConversionContext.TypeConversionContextBuilder)((TypeConversionContext.TypeConversionContextBuilder)((TypeConversionContext.TypeConversionContextBuilder)TypeConversionContext.builder().converter(this.converter)).currentConversionKey(conversionKey)).arguments(this.args)).build();
        return this.converter.convert(source, (TypeConversionContext)context);
    }
}

