/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api.context;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.Converter;
import org.hglteam.conversion.api.DefaultConversionKey;
import org.hglteam.conversion.api.context.ConversionContext;

public class ContextualConversionBuilder<T> {
    private final Converter converter;
    private final Map<Object, Object> args;
    private Type targetType;
    private Type sourceType;
    private ConversionKey conversionKey;

    public ContextualConversionBuilder(Converter converter, Type targetType) {
        this.converter = converter;
        this.targetType = targetType;
        this.args = new HashMap<Object, Object>();
    }

    public ContextualConversionBuilder(Converter converter, Class<? extends T> targetClass) {
        this(converter, (Type)targetClass);
    }

    public ContextualConversionBuilder<T> withConvertionKey(ConversionKey conversionKey) {
        this.conversionKey = conversionKey;
        return this;
    }

    public ContextualConversionBuilder<T> withSourceType(Type sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public ContextualConversionBuilder<T> withTargetType(Type targetType) {
        this.targetType = targetType;
        return this;
    }

    public ContextualConversionBuilder<T> withArgs(Map<Object, Object> args) {
        this.args.clear();
        this.args.putAll(args);
        return this;
    }

    public ContextualConversionBuilder<T> withArg(Object key, Object value) {
        this.args.put(key, value);
        return this;
    }

    public <S> T convert(S source) {
        ConversionKey finalConversionKey = Optional.ofNullable(this.conversionKey).orElseGet(() -> ((DefaultConversionKey.DefaultConversionKeyBuilder)((DefaultConversionKey.DefaultConversionKeyBuilder)DefaultConversionKey.builder().source(Objects.nonNull(this.sourceType) ? this.sourceType : source.getClass())).target(this.targetType)).build());
        Object context = ((ConversionContext.ConversionContextBuilder)((ConversionContext.ConversionContextBuilder)((ConversionContext.ConversionContextBuilder)ConversionContext.builder().converter(this.converter)).currentConversionKey(finalConversionKey)).arguments(this.args)).build();
        return this.converter.convert(source, (ConversionContext)context);
    }
}

