/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api;

import java.util.Collection;
import java.util.function.Supplier;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.TypeConverter;

public interface ConversionMap {
    public ConversionMap register(ConversionKey var1, TypeConverter<?, ?> var2);

    public ConversionMap register(TypeConverter<?, ?> var1);

    public TypeConverter<?, ?> resolve(ConversionKey var1);

    public Collection<ConversionKey> getAvailableConversions();

    public static class NoCompatibleKeyFoundException
    extends IllegalArgumentException {
        public NoCompatibleKeyFoundException(ConversionKey conversionKey) {
            super(String.format("%s -> %s", conversionKey.getSource(), conversionKey.getTarget()));
        }

        public static Supplier<NoCompatibleKeyFoundException> forKey(ConversionKey conversionKey) {
            return () -> new NoCompatibleKeyFoundException(conversionKey);
        }
    }

    public static class DuplicatedConversionKeyException
    extends IllegalArgumentException {
        public DuplicatedConversionKeyException(ConversionKey conversionKey) {
            super(String.format("(%s): %s -> %s", conversionKey, conversionKey.getSource(), conversionKey.getTarget()));
        }
    }
}

