/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.DefaultConversionKey;
import org.hglteam.conversion.api.ExplicitTypeConverter;
import org.hglteam.conversion.api.context.ConversionContext;

public abstract class GenericTypeConverter<S, T>
implements ExplicitTypeConverter<S, T> {
    private final BiFunction<ConversionContext, S, T> conversionFunction;
    private final ConversionKey conversionKey;

    public GenericTypeConverter(BiFunction<ConversionContext, S, T> conversionFunction) {
        this.conversionFunction = conversionFunction;
        this.conversionKey = GenericTypeConverter.inferConversionKey(this.getClass());
    }

    public GenericTypeConverter(Function<S, T> conversionFunction) {
        this.conversionFunction = (context, source) -> conversionFunction.apply(source);
        this.conversionKey = GenericTypeConverter.inferConversionKey(this.getClass());
    }

    @Override
    public T convert(ConversionContext context, S source) {
        return this.conversionFunction.apply(context, source);
    }

    private static ConversionKey inferConversionKey(Class<?> aClass) {
        Type superclass = aClass.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parameterizedClass = (ParameterizedType)superclass;
            return ((DefaultConversionKey.DefaultConversionKeyBuilder)((DefaultConversionKey.DefaultConversionKeyBuilder)DefaultConversionKey.builder().source(parameterizedClass.getActualTypeArguments()[0])).target(parameterizedClass.getActualTypeArguments()[1])).build();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ConversionKey getConversionKey() {
        return this.conversionKey;
    }
}

