/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.api.context;

import java.util.Map;
import java.util.Optional;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.Converter;

public class ConversionContext {
    private Converter converter;
    private ConversionKey currentConversionKey;
    private Map<Object, Object> arguments;

    public <T> T getArgument(Object key) {
        return this.argument(key).orElse(null);
    }

    public <T> Optional<T> argument(Object key) {
        return Optional.ofNullable(key).map(this.arguments::get).map(value -> value);
    }

    protected ConversionContext(ConversionContextBuilder<?, ?> b) {
        this.converter = b.converter;
        this.currentConversionKey = b.currentConversionKey;
        this.arguments = b.arguments;
    }

    public static ConversionContextBuilder<?, ?> builder() {
        return new ConversionContextBuilderImpl();
    }

    public ConversionContextBuilder<?, ?> toBuilder() {
        return new ConversionContextBuilderImpl().$fillValuesFrom(this);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public ConversionKey getCurrentConversionKey() {
        return this.currentConversionKey;
    }

    public Map<Object, Object> getArguments() {
        return this.arguments;
    }

    private static final class ConversionContextBuilderImpl
    extends ConversionContextBuilder<ConversionContext, ConversionContextBuilderImpl> {
        private ConversionContextBuilderImpl() {
        }

        @Override
        protected ConversionContextBuilderImpl self() {
            return this;
        }

        @Override
        public ConversionContext build() {
            return new ConversionContext(this);
        }
    }

    public static abstract class ConversionContextBuilder<C extends ConversionContext, B extends ConversionContextBuilder<C, B>> {
        private Converter converter;
        private ConversionKey currentConversionKey;
        private Map<Object, Object> arguments;

        protected B $fillValuesFrom(C instance) {
            ConversionContextBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ConversionContext instance, ConversionContextBuilder<?, ?> b) {
            b.converter(instance.converter);
            b.currentConversionKey(instance.currentConversionKey);
            b.arguments(instance.arguments);
        }

        protected abstract B self();

        public abstract C build();

        public B converter(Converter converter) {
            this.converter = converter;
            return this.self();
        }

        public B currentConversionKey(ConversionKey currentConversionKey) {
            this.currentConversionKey = currentConversionKey;
            return this.self();
        }

        public B arguments(Map<Object, Object> arguments) {
            this.arguments = arguments;
            return this.self();
        }

        public String toString() {
            return "ConversionContext.ConversionContextBuilder(converter=" + this.converter + ", currentConversionKey=" + this.currentConversionKey + ", arguments=" + this.arguments + ")";
        }
    }
}

