/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion;

import java.util.function.Function;
import org.hglteam.conversion.ConversionKeyResolver;
import org.hglteam.conversion.api.ConversionContext;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.Converter;
import org.hglteam.conversion.api.TypeConverter;

public class GenericConverter
implements Converter {
    private final ConversionContext conversionContext;

    public GenericConverter(ConversionContext conversionContext) {
        this.conversionContext = conversionContext;
    }

    public <TS, TD> TD convert(TS source, ConversionKey contersionKey) {
        TypeConverter converter = this.conversionContext.resolve(contersionKey);
        return (TD)converter.convert(source);
    }

    public <TS, TD> TD convert(TS source, Class<? extends TS> sourceClass, Class<? extends TD> targetClass) {
        return this.convert(source, ConversionKeyResolver.getConverterKey(sourceClass, targetClass));
    }

    public <TS, TD> TD convert(TS source, Class<? extends TD> targetClass) {
        return this.convert(source, source.getClass(), targetClass);
    }

    public <TS, TD> Function<TS, TD> convertTo(Class<? extends TS> sourceClass, Class<? extends TD> targetClass) {
        return source -> this.convert(source, sourceClass, targetClass);
    }

    public <TS, TD> Function<TS, TD> convertTo(Class<? extends TD> targetClass) {
        return source -> this.convert(source, targetClass);
    }

    public <TS, TD> Function<TS, TD> convertTo(ConversionKey conversionKey) {
        return source -> this.convert(source, conversionKey);
    }
}

