/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion;

import java.util.function.Function;
import org.hglteam.conversion.ConversionKeyResolver;
import org.hglteam.conversion.api.ConversionContext;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.Converter;
import org.hglteam.conversion.api.TypeConverter;
import org.hglteam.conversion.api.context.TypeConversionContext;

public class GenericConverter
implements Converter {
    private final ConversionContext conversionContext;

    public GenericConverter(ConversionContext conversionContext) {
        this.conversionContext = conversionContext;
    }

    public <TS, TD> TD convert(TS source, ConversionKey contersionKey, Object ... args) {
        TypeConverter converter = this.conversionContext.resolve(contersionKey);
        TypeConversionContext context = TypeConversionContext.builder().converter((Converter)this).currentConversionKey(contersionKey).arguments(args).build();
        return (TD)converter.convert(context, source);
    }

    public <TS, TD> TD convert(TS source, Class<? extends TS> sourceClass, Class<? extends TD> targetClass, Object ... args) {
        return this.convert(source, ConversionKeyResolver.getConverterKey(sourceClass, targetClass), args);
    }

    public <TS, TD> TD convert(TS source, Class<? extends TD> targetClass, Object ... args) {
        return this.convert(source, source.getClass(), targetClass, args);
    }

    public <TS, TD> Function<TS, TD> convertTo(Class<? extends TS> sourceClass, Class<? extends TD> targetClass, Object ... args) {
        return source -> this.convert(source, sourceClass, targetClass, args);
    }

    public <TS, TD> Function<TS, TD> convertTo(Class<? extends TD> targetClass, Object ... args) {
        return source -> this.convert(source, targetClass, args);
    }

    public <TS, TD> Function<TS, TD> convertTo(ConversionKey conversionKey, Object ... args) {
        return source -> this.convert(source, conversionKey, args);
    }
}

