/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.hglteam.conversion.ConversionKeyResolver;
import org.hglteam.conversion.api.ConversionContext;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.Converter;
import org.hglteam.conversion.api.TypeConverter;
import org.hglteam.conversion.api.context.ContextConversionBuilder;
import org.hglteam.conversion.api.context.TypeConversionContext;

public class GenericConverter
implements Converter {
    private final ConversionContext conversionContext;

    public GenericConverter(ConversionContext conversionContext) {
        this.conversionContext = conversionContext;
    }

    public <TS, TD> TD convert(TS source, TypeConversionContext context) {
        TypeConverter converter = this.conversionContext.resolve(context.getCurrentConversionKey());
        return (TD)converter.convert(context, source);
    }

    public <TS, TD> TD convert(TS source, ConversionKey contersionKey) {
        return this.convert(source, TypeConversionContext.builder().converter((Converter)this).currentConversionKey(contersionKey).arguments(null).build());
    }

    public <TS, TD> TD convert(TS source, Type sourceType, Type targetType) {
        return this.convert(source, ConversionKeyResolver.getConverterKey(sourceType, targetType));
    }

    public <TS, TD> TD convert(TS source, Type targetType) {
        return this.convert(source, source.getClass(), targetType);
    }

    public <TS, TD> Function<TS, TD> convertTo(Type sourceType, Type targetType) {
        return source -> this.convert(source, sourceType, targetType);
    }

    public <TS, TD> Function<TS, TD> convertTo(Type targetType) {
        return source -> this.convert(source, targetType);
    }

    public <TS, TD> Function<TS, TD> convertTo(ConversionKey conversionKey) {
        return source -> this.convert(source, conversionKey);
    }

    public <TD> ContextConversionBuilder<TD> withContext(Type targetClass) {
        return new ContextConversionBuilder((Converter)this, targetClass);
    }
}

