/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.DefaultConvertionKey;
import org.hglteam.conversion.api.TypeConverter;

public class ConversionTable {
    private final Map<Type, Map<Type, TypeConverter<?, ?>>> targetTable = new HashMap();

    public void put(Type sourceType, Type targetType, TypeConverter<?, ?> converter) {
        Map sourceTable = this.getByMatchingType(this.targetTable, targetType, HashMap::new);
        if (sourceTable.containsKey(sourceType)) {
            throw new DuplicatedConversionKeyException(sourceType, targetType);
        }
        sourceTable.put(sourceType, converter);
    }

    public TypeConverter<?, ?> getCompatibleConverter(ConversionKey conversionKey) {
        Map<Type, TypeConverter<?, ?>> sourceTable = this.getByMatchingType(this.targetTable, conversionKey.getTarget(), null);
        return Optional.ofNullable(sourceTable).map(table -> (TypeConverter)this.getByCompatibleType((Map)table, conversionKey.getSource())).orElseThrow(NoCompatibleKeyFoundException.forKey(conversionKey));
    }

    private <T> T getByMatchingType(Map<Type, T> map, Type key, Supplier<T> orElse) {
        if (!map.containsKey(key) && Objects.nonNull(orElse)) {
            map.put(key, orElse.get());
        }
        return map.get(key);
    }

    private <T> T getByCompatibleType(Map<Type, T> map, Type key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        Set<Type> keys = map.keySet();
        if (key instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)key;
            return (T)keys.stream().filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(type -> this.isAssignableFrom(parameterizedType, (ParameterizedType)type)).map(map::get).findFirst().orElseThrow(NoCompatibleKeyFoundException.forKey(key));
        }
        if (key instanceof Class) {
            Class keyClass = (Class)key;
            return (T)keys.stream().filter(Class.class::isInstance).map(Class.class::cast).filter(type -> type.isAssignableFrom(keyClass)).map(map::get).findFirst().orElseThrow(NoCompatibleKeyFoundException.forKey(key));
        }
        throw new NoCompatibleKeyFoundException(key);
    }

    private boolean isAssignableFrom(ParameterizedType source, ParameterizedType target) {
        return source.getRawType().equals(target.getRawType()) && source.getActualTypeArguments().length == target.getActualTypeArguments().length && IntStream.range(0, source.getActualTypeArguments().length).allMatch(index -> Objects.equals(source.getActualTypeArguments()[index], source.getActualTypeArguments()[index]));
    }

    public Collection<ConversionKey> getAvailableConversion() {
        return this.targetTable.keySet().stream().flatMap(targetKey -> this.targetTable.get(targetKey).keySet().stream().map(sourceKey -> DefaultConvertionKey.builder().source(sourceKey).target(targetKey).build())).collect(Collectors.toUnmodifiableSet());
    }

    public static class NoCompatibleKeyFoundException
    extends IllegalArgumentException {
        public NoCompatibleKeyFoundException(Type key) {
            super(Objects.toString(key));
        }

        public NoCompatibleKeyFoundException(ConversionKey conversionKey) {
            super(String.format("%s -> %s", conversionKey.getSource(), conversionKey.getTarget()));
        }

        public static Supplier<NoCompatibleKeyFoundException> forKey(Type key) {
            return () -> new NoCompatibleKeyFoundException(key);
        }

        public static Supplier<? extends NoCompatibleKeyFoundException> forKey(ConversionKey conversionKey) {
            return () -> new NoCompatibleKeyFoundException(conversionKey);
        }
    }

    public static class DuplicatedConversionKeyException
    extends IllegalArgumentException {
        public DuplicatedConversionKeyException(Type sourceType, Type targetType) {
            super(String.format("%s -> %s", sourceType, targetType));
        }
    }
}

