/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.DefaultConversionKey;
import org.hglteam.conversion.api.ExplicitTypeConverter;
import org.hglteam.conversion.api.TypeConverter;

public final class ConversionKeyResolver {
    private static final Map<Type, ConversionKey> previousMatches = new HashMap<Type, ConversionKey>();

    private ConversionKeyResolver() {
    }

    public static ConversionKey inferConversionKey(TypeConverter<?, ?> converter) {
        if (converter instanceof ExplicitTypeConverter) {
            return ((ExplicitTypeConverter)converter).getConversionKey();
        }
        Class<?> converterType = converter.getClass();
        if (!previousMatches.containsKey(converterType)) {
            previousMatches.put(converterType, ConversionKeyResolver.inferConversionKey(converterType, new HashMap<Type, Type>()));
        }
        return previousMatches.get(converterType);
    }

    private static ConversionKey inferConversionKey(Type source, Map<Type, Type> genericArgs) {
        if (source instanceof Class) {
            return ConversionKeyResolver.inferConversionKey((Class)source, genericArgs);
        }
        if (source instanceof ParameterizedType) {
            return ConversionKeyResolver.inferConversionKey((ParameterizedType)source, genericArgs);
        }
        return null;
    }

    private static ConversionKey inferConversionKey(Class<?> source, Map<Type, Type> genericArgs) {
        List resolvedTypeParams = ((Stream)Arrays.stream(source.getTypeParameters()).sequential()).map(typeParam -> ConversionKeyResolver.lookForLastValue(typeParam, genericArgs)).collect(Collectors.toList());
        if (Objects.equals(source, TypeConverter.class)) {
            return DefaultConversionKey.builder().source((Type)resolvedTypeParams.get(0)).target((Type)resolvedTypeParams.get(1)).build();
        }
        Type baseClass = source.getGenericSuperclass();
        Optional.of(baseClass).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).ifPresent(parameterizedType -> ConversionKeyResolver.scanTypeParameters(parameterizedType, genericArgs));
        Type[] interfaces = source.getGenericInterfaces();
        return Arrays.stream(interfaces).map(type -> ConversionKeyResolver.inferConversionKey(type, genericArgs)).filter(Objects::nonNull).findAny().orElseGet(() -> ConversionKeyResolver.inferConversionKey(baseClass, genericArgs));
    }

    private static ConversionKey inferConversionKey(ParameterizedType source, Map<Type, Type> genericArgs) {
        ConversionKeyResolver.scanTypeParameters(source, genericArgs);
        return ConversionKeyResolver.inferConversionKey(source.getRawType(), genericArgs);
    }

    private static void scanTypeParameters(ParameterizedType parameterizedType, Map<Type, Type> genericArgs) {
        Type[] actualParameters = parameterizedType.getActualTypeArguments();
        Class rawType = (Class)parameterizedType.getRawType();
        TypeVariable[] rawTypeArgs = rawType.getTypeParameters();
        IntStream.range(0, actualParameters.length).mapToObj(i -> Map.entry(rawTypeArgs[i], actualParameters[i])).forEach(pair -> genericArgs.put((Type)pair.getKey(), (Type)pair.getValue()));
    }

    private static Type lookForLastValue(Type type, Map<Type, Type> genericArgs) {
        Type current = type;
        while (genericArgs.containsKey(current)) {
            current = genericArgs.get(current);
        }
        genericArgs.replace(type, current);
        return current;
    }
}

