/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hglteam.conversion.ConversionKeyResolver;
import org.hglteam.conversion.TypeMatcher;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.ConversionMap;
import org.hglteam.conversion.api.ExplicitTypeConverter;
import org.hglteam.conversion.api.TypeConverter;

public class DefaultConversionMap
implements ConversionMap {
    private final Map<ConversionKey, TypeConverter<?, ?>> converterMap = new HashMap();
    private final Map<ConversionKey, ConversionKey> compatibilityMap = new HashMap<ConversionKey, ConversionKey>();

    public ConversionMap register(ConversionKey key, TypeConverter<?, ?> converter) {
        if (!this.converterMap.containsKey(key)) {
            this.converterMap.put(key, converter);
            return this;
        }
        throw new ConversionMap.DuplicatedConversionKeyException(key);
    }

    public ConversionMap register(TypeConverter<?, ?> converter) {
        ConversionKey conversionKey = Optional.of(converter).filter(ExplicitTypeConverter.class::isInstance).map(ExplicitTypeConverter.class::cast).map(ExplicitTypeConverter::getConversionKey).orElseGet(() -> ConversionKeyResolver.inferConversionKey(converter));
        this.register(conversionKey, converter);
        return this;
    }

    public TypeConverter<?, ?> resolve(ConversionKey key) {
        ConversionKey resolvedKey = Optional.of(key).filter(this.converterMap::containsKey).orElseGet(() -> this.getFirstCompatibleFrom(key, this.converterMap.keySet()));
        return Optional.ofNullable(resolvedKey).map(this.converterMap::get).orElseThrow(ConversionMap.NoCompatibleKeyFoundException.forKey((ConversionKey)key));
    }

    public Collection<ConversionKey> getAvailableConversions() {
        return Collections.unmodifiableSet(this.converterMap.keySet());
    }

    private ConversionKey getFirstCompatibleFrom(ConversionKey key, Set<ConversionKey> keySet) {
        if (!this.compatibilityMap.containsKey(key)) {
            keySet.stream().filter(conversionKey -> TypeMatcher.isAssignableFrom(key.getSource(), conversionKey.getSource()) && TypeMatcher.isAssignableFrom(key.getTarget(), conversionKey.getTarget())).findAny().ifPresent(compatibleKey -> this.compatibilityMap.put(key, (ConversionKey)compatibleKey));
        }
        return this.compatibilityMap.get(key);
    }
}

