/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.ConversionMap;
import org.hglteam.conversion.api.Converter;
import org.hglteam.conversion.api.DefaultConversionKey;
import org.hglteam.conversion.api.TypeConverter;
import org.hglteam.conversion.api.TypeDescriptor;
import org.hglteam.conversion.api.context.ContextualConversionBuilder;
import org.hglteam.conversion.api.context.ConversionContext;

public class DefaultConverter
implements Converter {
    private final ConversionMap conversionMap;

    public DefaultConverter(ConversionMap conversionMap) {
        this.conversionMap = conversionMap;
    }

    public <S, T> T convert(S source, ConversionContext context) {
        TypeConverter converter = this.conversionMap.resolve(context.getCurrentConversionKey());
        return (T)converter.convert(context, source);
    }

    public <S, T> T convert(S source, ConversionKey contersionKey) {
        return this.convert(source, ConversionContext.builder().converter((Converter)this).currentConversionKey(contersionKey).arguments(null).build());
    }

    public <S, T> T convert(S source, Type sourceType, Type targetType) {
        return this.convert(source, (ConversionKey)DefaultConversionKey.builder().source(sourceType).target(targetType).build());
    }

    public <S, T> T convert(S source, TypeDescriptor<? extends S> sourceType, TypeDescriptor<T> targetType) {
        return this.convert(source, sourceType.getType(), targetType.getType());
    }

    public <S, T> T convert(S source, Type targetType) {
        return this.convert(source, source.getClass(), targetType);
    }

    public <S, T> T convert(S source, TypeDescriptor<T> targetType) {
        return this.convert(source, source.getClass(), targetType.getType());
    }

    public <S, T> T convert(S source, Class<? extends T> targetClass) {
        return this.convert(source, (Type)targetClass);
    }

    public <S, T> Function<S, T> convertTo(ConversionContext context) {
        return source -> this.convert(source, context);
    }

    public <S, T> Function<S, T> convertTo(Type sourceType, Type targetType) {
        return source -> this.convert(source, sourceType, targetType);
    }

    public <S, T> Function<S, T> convertTo(TypeDescriptor<? extends S> sourceType, TypeDescriptor<T> targetType) {
        return source -> this.convert(source, sourceType, targetType);
    }

    public <S, T> Function<S, T> convertTo(Type targetType) {
        return source -> this.convert(source, targetType);
    }

    public <S, T> Function<S, T> convertTo(TypeDescriptor<T> targetType) {
        return source -> this.convert(source, targetType.getType());
    }

    public <S, T> Function<S, T> convertTo(Class<? extends T> targetClass) {
        return this.convertTo((Type)targetClass);
    }

    public <S, T> Function<S, T> convertTo(ConversionKey conversionKey) {
        return source -> this.convert(source, conversionKey);
    }

    public <T> ContextualConversionBuilder<T> withContext(Type targetClass) {
        return new ContextualConversionBuilder((Converter)this, targetClass);
    }

    public <T> ContextualConversionBuilder<T> withContext(Class<? extends T> targetClass) {
        return new ContextualConversionBuilder((Converter)this, targetClass);
    }

    public <T> ContextualConversionBuilder<T> withContext(TypeDescriptor<T> targetTypeDescriptor) {
        return new ContextualConversionBuilder((Converter)this, targetTypeDescriptor.getType());
    }
}

