/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hglteam.conversion.api.ConversionKey;
import org.hglteam.conversion.api.DefaultConversionKey;

public final class TypeMatcher {
    private static final Map<ConversionKey, Boolean> previousMatches = new HashMap<ConversionKey, Boolean>();

    private TypeMatcher() {
    }

    public static boolean isAssignableFrom(Type source, Type target) {
        DefaultConversionKey convertionKey = DefaultConversionKey.builder().source(source).target(target).build();
        if (!previousMatches.containsKey(convertionKey)) {
            previousMatches.put((ConversionKey)convertionKey, TypeMatcher.isAssignableFrom(source, target, new HashMap<Type, Type>()));
        }
        return previousMatches.get(convertionKey);
    }

    private static boolean isAssignableFrom(Type source, Type target, Map<Type, Type> genericArgs) {
        if (Objects.isNull(source) || Objects.equals(Object.class, source)) {
            return false;
        }
        if (source instanceof Class) {
            return TypeMatcher.isAssignableFrom((Class)source, target, genericArgs);
        }
        if (source instanceof ParameterizedType) {
            return TypeMatcher.isAssignableFrom((ParameterizedType)source, target, genericArgs);
        }
        return false;
    }

    private static boolean isAssignableFrom(Class<?> source, Type target, Map<Type, Type> genericArgs) {
        if (target instanceof Class && ((Class)target).isAssignableFrom(source)) {
            return true;
        }
        if (target instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)target;
            return Arrays.stream(wildcard.getUpperBounds()).allMatch(bound -> TypeMatcher.isAssignableFrom(source, bound));
        }
        if (target instanceof ParameterizedType) {
            ParameterizedType parameterizedTarget = (ParameterizedType)target;
            List resolvedTypeParams = ((Stream)Arrays.stream(source.getTypeParameters()).sequential()).map(typeParam -> TypeMatcher.lookForLastValue(typeParam, genericArgs)).collect(Collectors.toList());
            Class targetClass = (Class)parameterizedTarget.getRawType();
            if (Objects.equals(source, targetClass)) {
                List<Type> resolvedTargetArgs = Arrays.asList(parameterizedTarget.getActualTypeArguments());
                return IntStream.range(0, resolvedTargetArgs.size()).allMatch(i -> TypeMatcher.isAssignableFrom((Type)resolvedTypeParams.get(i), (Type)resolvedTargetArgs.get(i), new HashMap<Type, Type>()));
            }
            Type baseClass = source.getGenericSuperclass();
            Type[] interfaces = source.getGenericInterfaces();
            return TypeMatcher.isAssignableFrom(baseClass, target, genericArgs) || Arrays.stream(interfaces).anyMatch(type -> TypeMatcher.isAssignableFrom(type, target, genericArgs));
        }
        return false;
    }

    private static boolean isAssignableFrom(ParameterizedType type, Type target, Map<Type, Type> genericArgs) {
        TypeMatcher.scanTypeParameters(type, genericArgs);
        return TypeMatcher.isAssignableFrom((Class)type.getRawType(), target, genericArgs);
    }

    private static void scanTypeParameters(ParameterizedType parameterizedType, Map<Type, Type> genericArgs) {
        Type[] actualParameters = parameterizedType.getActualTypeArguments();
        Class rawType = (Class)parameterizedType.getRawType();
        TypeVariable[] rawTypeArgs = rawType.getTypeParameters();
        IntStream.range(0, actualParameters.length).mapToObj(i -> Map.entry(rawTypeArgs[i], actualParameters[i])).forEach(pair -> genericArgs.put((Type)pair.getKey(), (Type)pair.getValue()));
    }

    private static Type lookForLastValue(Type type, Map<Type, Type> genericArgs) {
        Type current = type;
        while (genericArgs.containsKey(current)) {
            current = genericArgs.get(current);
        }
        genericArgs.replace(type, current);
        return current;
    }
}

