/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.conversion.datetime;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hglteam.conversion.api.datetime.DateFormatMap;
import org.hglteam.conversion.api.datetime.DateFormatter;

public class DefaultDateFormatter
implements DateFormatter {
    private final DateFormatMap context;

    public DefaultDateFormatter(DateFormatMap context) {
        this.context = context;
    }

    private DateFormat getLegacyFormatter(String pattern, Locale locale) {
        DateFormat formatter = this.context.resolveLegacyFormatter(pattern, locale);
        if (Objects.isNull(formatter)) {
            this.context.registerLegacy(pattern, locale);
            formatter = this.context.resolveLegacyFormatter(pattern, locale);
        }
        return formatter;
    }

    private DateTimeFormatter getFormatter(String pattern, Locale locale) {
        DateTimeFormatter formatter = this.context.resolveFormatter(pattern, locale);
        if (Objects.isNull(formatter)) {
            this.context.register(pattern, locale);
            formatter = this.context.resolveFormatter(pattern, locale);
        }
        return formatter;
    }

    public String format(Date date, String pattern, Locale locale) {
        return this.getLegacyFormatter(pattern, locale).format(date);
    }

    public String format(Date date, String pattern) {
        return this.format(date, pattern, Locale.getDefault());
    }

    public String format(TemporalAccessor temporal, String pattern, Locale locale) {
        return this.getFormatter(pattern, locale).format(temporal);
    }

    public String format(TemporalAccessor temporal, String pattern) {
        return this.format(temporal, pattern, Locale.getDefault());
    }

    public Function<Date, String> format(String pattern, Locale locale) {
        return date -> this.format((Date)date, pattern, locale);
    }

    public Function<Date, String> format(String pattern) {
        return date -> this.format((Date)date, pattern);
    }

    public <T extends TemporalAccessor> Function<T, String> formatTemporal(String pattern, Locale locale) {
        return temporal -> this.format((TemporalAccessor)temporal, pattern, locale);
    }

    public <T extends TemporalAccessor> Function<T, String> formatTemporal(String pattern) {
        return temporal -> this.format((TemporalAccessor)temporal, pattern);
    }

    public Date toDate(String value, String pattern, Locale locale) {
        try {
            return this.getLegacyFormatter(pattern, locale).parse(value);
        }
        catch (ParseException e) {
            throw new DateFormatter.DateFormattingException((Throwable)e, value, pattern, locale);
        }
    }

    public Date toDate(String value, String pattern) {
        return this.toDate(value, pattern, Locale.getDefault());
    }

    public <T extends TemporalAccessor> T toTemporal(BiFunction<String, DateTimeFormatter, T> parser, String value, String pattern, Locale locale) {
        return (T)((TemporalAccessor)parser.apply(value, this.getFormatter(pattern, locale)));
    }

    public <T extends TemporalAccessor> T toTemporal(BiFunction<String, DateTimeFormatter, T> parser, String value, String pattern) {
        return this.toTemporal(parser, value, pattern, Locale.getDefault());
    }

    public <T extends TemporalAccessor> Function<String, T> toTemporal(BiFunction<String, DateTimeFormatter, T> parser, String pattern, Locale locale) {
        return value -> this.toTemporal(parser, (String)value, pattern, locale);
    }

    public <T extends TemporalAccessor> Function<String, T> toTemporal(BiFunction<String, DateTimeFormatter, T> parser, String pattern) {
        return this.toTemporal(parser, pattern, Locale.getDefault());
    }
}

