/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion.api;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import org.hglteam.convertion.api.TypeConverter;

public interface ConversionContext {
    public <TS, TD> TypeConverter<TS, TD> resolve(Class<? extends TS> var1, Class<? extends TD> var2);

    public ConversionContext register(TypeConverter<?, ?> var1);

    public Collection<ConversionPair> getAvailableConversionPairs();

    public static class ConversionPair {
        private Type source;
        private Type target;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConversionPair that = (ConversionPair)o;
            return this.source.equals(that.source) && this.target.equals(that.target);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target);
        }

        protected ConversionPair(ConversionPairBuilder<?, ?> b) {
            this.source = b.source;
            this.target = b.target;
        }

        public static ConversionPairBuilder<?, ?> builder() {
            return new ConversionPairBuilderImpl();
        }

        public Type getSource() {
            return this.source;
        }

        public Type getTarget() {
            return this.target;
        }

        public ConversionPair() {
        }

        private static final class ConversionPairBuilderImpl
        extends ConversionPairBuilder<ConversionPair, ConversionPairBuilderImpl> {
            private ConversionPairBuilderImpl() {
            }

            @Override
            protected ConversionPairBuilderImpl self() {
                return this;
            }

            @Override
            public ConversionPair build() {
                return new ConversionPair(this);
            }
        }

        public static abstract class ConversionPairBuilder<C extends ConversionPair, B extends ConversionPairBuilder<C, B>> {
            private Type source;
            private Type target;

            protected abstract B self();

            public abstract C build();

            public B source(Type source) {
                this.source = source;
                return this.self();
            }

            public B target(Type target) {
                this.target = target;
                return this.self();
            }

            public String toString() {
                return "ConversionContext.ConversionPair.ConversionPairBuilder(source=" + this.source + ", target=" + this.target + ")";
            }
        }
    }
}

