/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hglteam.convertion.ConverterKey;
import org.hglteam.convertion.api.TypeConverter;

public class ConverterKeyResolver {
    public static ConverterKey getConverterKey(TypeConverter<?, ?> obj) {
        Class<?>[] genericTypes = ConverterKeyResolver.getGenericConverterTypes(obj);
        return Optional.of(genericTypes).filter(converterGenericTypes -> ((Class[])converterGenericTypes).length == 2).map(converterGenericTypes -> new ConverterKey(converterGenericTypes[0], converterGenericTypes[1])).orElseThrow(() -> new InvalidConvertionTypeException());
    }

    private static Class<?>[] getGenericConverterTypes(Object instance) {
        HashMap<Type, Type> argumentMap = new HashMap<Type, Type>();
        Class currentSuperClass = instance.getClass();
        ParameterizedType converterInterfaceType = null;
        while (currentSuperClass != null && converterInterfaceType == null) {
            ConverterKeyResolver.getGenericTypeArguments(argumentMap, currentSuperClass);
            converterInterfaceType = ConverterKeyResolver.getConverterInterface(currentSuperClass);
            currentSuperClass = Optional.of(currentSuperClass).map(Class::getSuperclass).orElseThrow(IllegalArgumentException::new);
        }
        if (Objects.isNull(converterInterfaceType)) {
            throw new InvalidConvertionTypeException();
        }
        return (Class[])Arrays.stream(converterInterfaceType.getActualTypeArguments()).map(type -> Optional.of(type).filter(argumentMap::containsKey).map(argumentMap::get).orElse((Type)type)).filter(Class.class::isInstance).map(Class.class::cast).toArray(Class[]::new);
    }

    private static ParameterizedType getConverterInterface(Class<?> superclass) {
        return Arrays.stream(superclass.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(ptype -> TypeConverter.class.isAssignableFrom((Class)ptype.getRawType())).findAny().orElse(null);
    }

    private static void getGenericTypeArguments(Map<Type, Type> mapaArgumentos, Class<?> instanceClass) {
        Type superclass = instanceClass.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parametricSuperclass = (ParameterizedType)superclass;
            TypeVariable<Class<T>>[] genericTypeParameters = ((Class)parametricSuperclass.getRawType()).getTypeParameters();
            Type[] genericTypeArguments = parametricSuperclass.getActualTypeArguments();
            for (int i = 0; i < genericTypeParameters.length; ++i) {
                mapaArgumentos.put(genericTypeParameters[i], Optional.of(genericTypeArguments[i]).filter(mapaArgumentos::containsKey).map(mapaArgumentos::get).orElse(genericTypeArguments[i]));
            }
        }
    }

    private static class InvalidConvertionTypeException
    extends IllegalArgumentException {
        private InvalidConvertionTypeException() {
        }
    }
}

