/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hglteam.convertion.LocalizedDatePatternKey;
import org.hglteam.convertion.api.DateFormatterContext;

public class GenericDateFormatterContext
implements Serializable,
DateFormatterContext {
    private Map<LocalizedDatePatternKey, DateFormat> legacyFormatters = new HashMap<LocalizedDatePatternKey, DateFormat>();
    private Map<LocalizedDatePatternKey, DateTimeFormatter> formatters = new HashMap<LocalizedDatePatternKey, DateTimeFormatter>();

    public DateFormatterContext registerLegacy(String format, Locale locale) {
        this.legacyFormatters.put(new LocalizedDatePatternKey(format, locale), new SimpleDateFormat(format, locale));
        return this;
    }

    public DateFormatterContext register(String format, Locale locale) {
        this.formatters.put(new LocalizedDatePatternKey(format, locale), DateTimeFormatter.ofPattern(format, locale));
        return this;
    }

    public DateFormat resolveLegacyFormatter(String pattern, Locale locale) {
        return this.legacyFormatters.get(new LocalizedDatePatternKey(pattern, locale));
    }

    public DateTimeFormatter resolveFormatter(String pattern, Locale locale) {
        return this.formatters.get(new LocalizedDatePatternKey(pattern, locale));
    }
}

