/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hglteam.convertion.ConverterKey;
import org.hglteam.convertion.ConverterKeyResolver;
import org.hglteam.convertion.api.ConverterContext;
import org.hglteam.convertion.api.TypeConverter;

public class ConvertionContextMap
implements ConverterContext {
    private final Map<ConverterKey, TypeConverter<?, ?>> converterMap = new HashMap();

    public <TS, TD> TypeConverter<TS, TD> resolve(Class<? extends TS> sourceClass, Class<? extends TD> destinationClass) {
        return Optional.of(new ConverterKey(sourceClass, destinationClass)).map(this::getConverter).orElseThrow(() -> new ConverterNotFoundException(sourceClass, destinationClass));
    }

    public ConverterContext register(TypeConverter<?, ?> converter) {
        this.converterMap.put(ConverterKeyResolver.getConverterKey(converter), converter);
        return this;
    }

    private <TS, TD> TypeConverter<TS, TD> getConverter(ConverterKey key) {
        return this.converterMap.keySet().stream().filter(k -> k.equals(key)).findAny().map(this.converterMap::get).map(TypeConverter.class::cast).orElseThrow();
    }

    public static class ConverterNotFoundException
    extends IllegalArgumentException {
        private final Class<?> sourceClass;
        private final Class<?> destinationClass;

        public ConverterNotFoundException(Class<?> sourceClass, Class<?> destinationClass) {
            this.sourceClass = sourceClass;
            this.destinationClass = destinationClass;
        }

        public Class<?> getSourceClass() {
            return this.sourceClass;
        }

        public Class<?> getDestinationClass() {
            return this.destinationClass;
        }
    }
}

