/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public class ConversionKey {
    private final Type sourceClass;
    private final Type targetClass;

    public ConversionKey(Type sourceClass, Type targetClass) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    public Type getSourceClass() {
        return this.sourceClass;
    }

    public Type getTargetClass() {
        return this.targetClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionKey that = (ConversionKey)o;
        boolean sourceCompatibility = this.checkTypeCompatibility(this.sourceClass, that.sourceClass);
        boolean targetCompatibility = this.checkTypeCompatibility(this.targetClass, that.targetClass);
        return sourceCompatibility && targetCompatibility;
    }

    public int hashCode() {
        return Objects.hash(this.sourceClass, this.targetClass);
    }

    private boolean checkTypeCompatibility(Type thisType, Type thatType) {
        Class thatClass;
        Class thisClass;
        Class clazz = thisType instanceof Class ? (Class)thisType : (thisClass = thisType instanceof ParameterizedType ? (Class)((ParameterizedType)thisType).getRawType() : null);
        Class clazz2 = thatType instanceof Class ? (Class)thatType : (thatClass = thatType instanceof ParameterizedType ? (Class)((ParameterizedType)thatType).getRawType() : null);
        if (Objects.nonNull(thisClass) && Objects.nonNull(thatClass)) {
            return thisClass.isAssignableFrom(thatClass);
        }
        return Objects.equals(thisType, thatType);
    }
}

