/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hglteam.convertion.ConversionKey;
import org.hglteam.convertion.ConversionKeyResolver;
import org.hglteam.convertion.api.ConversionContext;
import org.hglteam.convertion.api.TypeConverter;

public class ConversionContextMap
implements ConversionContext {
    private final Map<ConversionKey, TypeConverter<?, ?>> converterMap = new HashMap();

    public <TS, TD> TypeConverter<TS, TD> resolve(Class<? extends TS> sourceClass, Class<? extends TD> destinationClass) {
        return Optional.of(new ConversionKey(sourceClass, destinationClass)).map(this::getConverter).orElseThrow(() -> ConverterNotFoundException.of(sourceClass, destinationClass));
    }

    public ConversionContext register(TypeConverter<?, ?> converter) {
        this.converterMap.put(ConversionKeyResolver.getConverterKey(converter), converter);
        return this;
    }

    public Collection<ConversionContext.ConversionPair> getAvailableConversionPairs() {
        return this.converterMap.keySet().stream().map(key -> ConversionContext.ConversionPair.builder().source(key.getSourceClass()).target(key.getTargetClass()).build()).collect(Collectors.toUnmodifiableSet());
    }

    private <TS, TD> TypeConverter<TS, TD> getConverter(ConversionKey key) {
        return this.converterMap.keySet().stream().filter(k -> k.equals(key)).findAny().map(this.converterMap::get).map(TypeConverter.class::cast).orElseThrow(() -> ConverterNotFoundException.of(key));
    }

    public static class ConverterNotFoundException
    extends IllegalArgumentException {
        private static final String CONVERSION_PAIR = "%s -> %s";
        private final Type sourceType;
        private final Type targetType;

        public ConverterNotFoundException(Type sourceType, Type targetType) {
            super(String.format(CONVERSION_PAIR, sourceType, targetType));
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public Type getSourceType() {
            return this.sourceType;
        }

        public Type getTargetType() {
            return this.targetType;
        }

        public static ConverterNotFoundException of(Type sourceType, Type targetType) {
            return new ConverterNotFoundException(sourceType, targetType);
        }

        public static ConverterNotFoundException of(ConversionKey key) {
            return ConverterNotFoundException.of(key.getSourceClass(), key.getTargetClass());
        }
    }
}

