/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hglteam.convertion.ConversionKey;
import org.hglteam.convertion.api.TypeConverter;

public class ConversionKeyResolver {
    public static ConversionKey getConverterKey(TypeConverter<?, ?> obj) {
        Type[] genericTypes = ConversionKeyResolver.getGenericConverterTypes(obj);
        return Optional.of(genericTypes).filter(converterGenericTypes -> ((Type[])converterGenericTypes).length == 2).map(converterGenericTypes -> new ConversionKey(converterGenericTypes[0], converterGenericTypes[1])).orElseThrow(() -> InvalidConvertionTypeException.fromPartialResult(genericTypes));
    }

    private static Type[] getGenericConverterTypes(Object instance) {
        HashMap<Type, Type> argumentMap = new HashMap<Type, Type>();
        Class currentSuperClass = instance.getClass();
        ParameterizedType converterInterfaceType = null;
        while (currentSuperClass != null && converterInterfaceType == null) {
            ConversionKeyResolver.getGenericTypeArguments(argumentMap, currentSuperClass);
            converterInterfaceType = ConversionKeyResolver.getConverterInterface(currentSuperClass);
            currentSuperClass = Optional.of(currentSuperClass).map(Class::getSuperclass).orElseThrow(IllegalArgumentException::new);
        }
        if (Objects.isNull(converterInterfaceType)) {
            throw InvalidConvertionTypeException.fromInstance(instance);
        }
        return (Type[])Arrays.stream(converterInterfaceType.getActualTypeArguments()).map(type -> Optional.of(type).filter(argumentMap::containsKey).map(argumentMap::get).orElse((Type)type)).toArray(Type[]::new);
    }

    private static ParameterizedType getConverterInterface(Class<?> superclass) {
        return Arrays.stream(superclass.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(ptype -> TypeConverter.class.isAssignableFrom((Class)ptype.getRawType())).findAny().orElse(null);
    }

    private static void getGenericTypeArguments(Map<Type, Type> argumentType, Class<?> instanceClass) {
        Type superclass = instanceClass.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parametricSuperclass = (ParameterizedType)superclass;
            TypeVariable<Class<T>>[] genericTypeParameters = ((Class)parametricSuperclass.getRawType()).getTypeParameters();
            Type[] genericTypeArguments = parametricSuperclass.getActualTypeArguments();
            for (int i = 0; i < genericTypeParameters.length; ++i) {
                argumentType.put(genericTypeParameters[i], Optional.of(genericTypeArguments[i]).filter(argumentType::containsKey).map(argumentType::get).orElse(genericTypeArguments[i]));
            }
        }
    }

    private static class InvalidConvertionTypeException
    extends IllegalArgumentException {
        private static final String PARTIAL_RESULT_MESSAGE_FORMAT = "Partial types found: %s";
        private static final String INVALID_INSTANCE_MESSAGE_FORMAT = "Illegal instance type %s";

        public InvalidConvertionTypeException(String message) {
            super(message);
        }

        public static InvalidConvertionTypeException fromPartialResult(Type[] partialResults) {
            return new InvalidConvertionTypeException(String.format(PARTIAL_RESULT_MESSAGE_FORMAT, Arrays.toString(partialResults)));
        }

        public static InvalidConvertionTypeException fromInstance(Object instance) {
            return new InvalidConvertionTypeException(String.format(INVALID_INSTANCE_MESSAGE_FORMAT, instance.getClass()));
        }
    }
}

