/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.convertion;

import java.util.function.Function;
import org.hglteam.convertion.api.ConversionContext;
import org.hglteam.convertion.api.Converter;
import org.hglteam.convertion.api.TypeConverter;

public class GenericConverter
implements Converter {
    private final ConversionContext conversionContext;

    public GenericConverter(ConversionContext conversionContext) {
        this.conversionContext = conversionContext;
    }

    public <TS, TD> TD convert(TS source, Class<? extends TS> sourceClass, Class<? extends TD> targetClass) {
        TypeConverter converter = this.conversionContext.resolve(sourceClass, targetClass);
        return (TD)converter.convert(source);
    }

    public <TS, TD> TD convert(TS source, Class<? extends TD> targetClass) {
        return this.convert(source, source.getClass(), targetClass);
    }

    public <TS, TD> Function<TS, TD> convertTo(Class<? extends TS> sourceClass, Class<? extends TD> targetClass) {
        return source -> this.convert(source, sourceClass, targetClass);
    }

    public <TS, TD> Function<TS, TD> convertTo(Class<? extends TD> targetClass) {
        return source -> this.convert(source, targetClass);
    }
}

