package org.hglteam.platform.config;

import com.google.gson.Gson;
import org.hglteam.platform.config.conditional.DatabaseAvailable;
import org.hglteam.platform.config.settings.SettingsFactory;
import org.hglteam.platform.resource.UrlSettingsResolver;
import org.hglteam.platform.settings.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import java.util.stream.Collectors;

@Configuration
public class SettingsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SettingsConfiguration.class);

    @Bean
    public UrlSettingsResolver resolver(Gson gson) {
        return new UrlSettingsResolver(gson);
    }

    @Bean
    @Conditional(DatabaseAvailable.class)
    public DatasourceSettings datasourceSettings(Environment environment) {
        var parameter = SettingsFactory.datasource(environment);

        log.debug("Database connection: {}", parameter);

        return parameter;
    }

    @Bean
    public AuthorizationSettings authorizationPolicies(Environment environment, UrlSettingsResolver resolver) {
        var parameter = SettingsFactory.authorizations(environment, resolver);

        log.debug("Authorization Policies: \n{}", parameter.toBuilder());

        return parameter;
    }

    @Bean
    public CorsSettings corsSettings(Environment environment, UrlSettingsResolver resolver) {
        var parameter = SettingsFactory.cors(environment, resolver);

        log.debug("Cors Mappins: \n{}", parameter.getMappings().stream()
                .map(Object::toString)
                .collect(Collectors.joining(System.lineSeparator())));

        return parameter;
    }

    @Bean
    public LocalizationSettings localizationParameter(Environment environment) {
        var parameters = SettingsFactory.localization(environment);

        log.debug("Localization Parameters: {}", parameters);

        return parameters;
    }

    @Bean
    public ClaimPathSettings claimPathSettings(Environment environment) {
        var parameter = SettingsFactory.claimPaths(environment);

        log.debug("Claim Paths: {}", parameter);

        return parameter;
    }
}
