/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.platform.config.settings;

import com.google.gson.reflect.TypeToken;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.hglteam.platform.resource.UrlSettingsResolver;
import org.hglteam.platform.settings.AuthorizationSettings;
import org.hglteam.platform.settings.ClaimPathSettings;
import org.hglteam.platform.settings.CorsSettings;
import org.hglteam.platform.settings.DatasourceSettings;
import org.hglteam.platform.settings.LocalizationSettings;
import org.hglteam.platform.settings.security.AuthorizationPolicy;
import org.hglteam.platform.settings.security.CorsMapping;
import org.springframework.core.env.Environment;

public final class SettingsFactory {
    public static final String APPLICATION_SECURITY_AUTHORIZATIONS = "application.security.authorizations";
    public static final String APPLICATION_SECURITY_CLAIM_PATHS_EMAIL = "application.security.claim.paths.email";
    public static final String APPLICATION_SECURITY_CLAIM_PATHS_PREFERRED_USERNAME = "application.security.claim.paths.preferred-username";
    public static final String APPLICATION_SECURITY_CLAIM_PATHS_USER_IDENTIFIER = "application.security.claim.paths.user-identifier";
    public static final String APPLICATION_SECURITY_CLAIM_PATHS_REALM_ACCESS = "application.security.claim.paths.realm-access";
    public static final String APPLICATION_SECURITY_CORS_MAPPINGS = "application.security.cors.mappings";
    public static final String APPLICATION_DATASOURCE_DRIVER = "application.datasource.driver";
    public static final String APPLICATION_DATASOURCE_URL = "application.datasource.url";
    public static final String APPLICATION_DATASOURCE_USERNAME = "application.datasource.username";
    public static final String APPLICATION_DATASOURCE_PASSWORD = "application.datasource.password";
    public static final String APPLICATION_DATASOURCE_IS_JNDI = "application.datasource.is-jndi";
    public static final String APPLICATION_DATASOURCE_JNDI_NAME = "application.datasource.jndi-name";
    public static final String CONFIG_JPA_PROVIDED = "config.jpa.provided";
    public static final String APPLICATION_LOCALIZATION_TIME_ZONE_ID = "application.localization.time.zone-id";
    public static final String APPLICATION_JSON_FORMAT_LOCAL_DATE = "application.json.format.local-date";
    public static final String APPLICATION_JSON_FORMAT_LOCAL_TIME = "application.json.format.local-time";
    public static final String APPLICATION_JSON_FORMAT_LOCAL_DATETIME = "application.json.format.local-datetime";
    private static final String DEFAULT_EMAIL_PATH = "$email";
    private static final String DEFAULT_PREFERRED_USERNAME_PATH = "$preferred_username";
    private static final String DEFAULT_USER_IDENTIFIER_PATH = "$sub";
    private static final String DEFAULT_REALM_ACCESS_PATH = "$realm_access.roles[*]";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";

    private SettingsFactory() {
    }

    public static AuthorizationSettings authorizations(Environment environment, UrlSettingsResolver resolver) {
        List policies = Optional.of(APPLICATION_SECURITY_AUTHORIZATIONS).map(arg_0 -> ((Environment)environment).getProperty(arg_0)).filter(Predicate.not(String::isBlank)).map(value -> (List)resolver.loadSettings(value, new TypeToken<List<AuthorizationPolicy>>(){}.getType())).orElse(Collections.emptyList());
        return AuthorizationSettings.builder().policies(policies).build();
    }

    public static CorsSettings cors(Environment environment, UrlSettingsResolver resolver) {
        List mappings = Optional.of(APPLICATION_SECURITY_CORS_MAPPINGS).map(arg_0 -> ((Environment)environment).getProperty(arg_0)).filter(Predicate.not(String::isBlank)).map(value -> (List)resolver.loadSettings(value, new TypeToken<List<CorsMapping>>(){}.getType())).orElse(Collections.emptyList());
        return CorsSettings.builder().mappings(mappings).build();
    }

    public static ClaimPathSettings claimPaths(Environment environment) {
        return ClaimPathSettings.builder().email(environment.getProperty(APPLICATION_SECURITY_CLAIM_PATHS_EMAIL, DEFAULT_EMAIL_PATH)).preferredUsername(environment.getProperty(APPLICATION_SECURITY_CLAIM_PATHS_PREFERRED_USERNAME, DEFAULT_PREFERRED_USERNAME_PATH)).userIdentifier(environment.getProperty(APPLICATION_SECURITY_CLAIM_PATHS_USER_IDENTIFIER, DEFAULT_USER_IDENTIFIER_PATH)).realmAccess(environment.getProperty(APPLICATION_SECURITY_CLAIM_PATHS_REALM_ACCESS, DEFAULT_REALM_ACCESS_PATH)).build();
    }

    public static DatasourceSettings datasource(Environment environment) {
        return DatasourceSettings.builder().driverClassName(environment.getProperty(APPLICATION_DATASOURCE_DRIVER)).url(environment.getProperty(APPLICATION_DATASOURCE_URL)).username(environment.getProperty(APPLICATION_DATASOURCE_USERNAME)).password(environment.getProperty(APPLICATION_DATASOURCE_PASSWORD)).isJndi(((Boolean)environment.getProperty(APPLICATION_DATASOURCE_IS_JNDI, Boolean.class, (Object)Boolean.FALSE)).booleanValue()).jndiName(environment.getProperty(APPLICATION_DATASOURCE_JNDI_NAME)).jpaProvided(((Boolean)environment.getProperty(CONFIG_JPA_PROVIDED, Boolean.class, (Object)Boolean.FALSE)).booleanValue()).build();
    }

    public static LocalizationSettings localization(Environment environment) {
        return LocalizationSettings.builder().zoneId(ZoneId.of(environment.getProperty(APPLICATION_LOCALIZATION_TIME_ZONE_ID, ZoneId.systemDefault().getId()))).localDateFormat(environment.getProperty(APPLICATION_JSON_FORMAT_LOCAL_DATE, DEFAULT_DATE_FORMAT)).localTimeFormat(environment.getProperty(APPLICATION_JSON_FORMAT_LOCAL_TIME, DEFAULT_TIME_FORMAT)).localDateTimeFormat(environment.getProperty(APPLICATION_JSON_FORMAT_LOCAL_DATETIME, DEFAULT_DATE_TIME_FORMAT)).build();
    }
}

