package org.hglteam.platform.config;

import org.hglteam.platform.config.conditional.DatabaseAvailable;
import org.hglteam.platform.config.settings.SettingsFactory;
import org.hglteam.platform.resource.DataResourceReader;
import org.hglteam.platform.resource.DefaultDataResourceReader;
import org.hglteam.platform.settings.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SettingsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SettingsConfiguration.class);

    @Bean
    public DataResourceReader dataResourceReader() {
        return new DefaultDataResourceReader();
    }

    @Bean
    @Conditional(DatabaseAvailable.class)
    public DatasourceSettings datasourceSettings(Environment environment) {
        var parameter = SettingsFactory.datasource(environment);

        log.debug("Database connection: {}", parameter);

        return parameter;
    }

    @Bean
    public AuthorizationSettings authorizationPolicies(ApplicationContext applicationContext) {
        var parameter = SettingsFactory.authorizations(applicationContext);

        log.debug("Authorization Policies: \n{}", parameter.toBuilder());

        return parameter;
    }

    @Bean
    public CorsSettings corsSettings(ApplicationContext applicationContext) {
        var parameter = SettingsFactory.cors(applicationContext);

        log.debug("Cors Mappins: \n{}", parameter);

        return parameter;
    }

    @Bean
    public LocalizationSettings localizationParameter(Environment environment) {
        var parameters = SettingsFactory.localization(environment);

        log.debug("Localization Parameters: {}", parameters);

        return parameters;
    }

    @Bean
    public ClaimPathSettings claimPathSettings(Environment environment) {
        var parameter = SettingsFactory.claimPaths(environment);

        log.debug("Claim Paths: {}", parameter);

        return parameter;
    }
}
