/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.platform.config;

import org.hglteam.platform.config.conditional.DatabaseAvailable;
import org.hglteam.platform.config.settings.SettingsFactory;
import org.hglteam.platform.resource.DataResourceReader;
import org.hglteam.platform.resource.DefaultDataResourceReader;
import org.hglteam.platform.settings.AuthorizationSettings;
import org.hglteam.platform.settings.ClaimPathSettings;
import org.hglteam.platform.settings.CorsSettings;
import org.hglteam.platform.settings.DatasourceSettings;
import org.hglteam.platform.settings.LocalizationSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SettingsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SettingsConfiguration.class);

    @Bean
    public DataResourceReader dataResourceReader() {
        return new DefaultDataResourceReader();
    }

    @Bean
    @Conditional(value={DatabaseAvailable.class})
    public DatasourceSettings datasourceSettings(Environment environment) {
        DatasourceSettings parameter = SettingsFactory.datasource(environment);
        log.debug("Database connection: {}", (Object)parameter);
        return parameter;
    }

    @Bean
    public AuthorizationSettings authorizationPolicies(ApplicationContext applicationContext) {
        AuthorizationSettings parameter = SettingsFactory.authorizations(applicationContext);
        log.debug("Authorization Policies: \n{}", (Object)parameter.toBuilder());
        return parameter;
    }

    @Bean
    public CorsSettings corsSettings(ApplicationContext applicationContext) {
        CorsSettings parameter = SettingsFactory.cors(applicationContext);
        log.debug("Cors Mappins: \n{}", (Object)parameter);
        return parameter;
    }

    @Bean
    public LocalizationSettings localizationParameter(Environment environment) {
        LocalizationSettings parameters = SettingsFactory.localization(environment);
        log.debug("Localization Parameters: {}", (Object)parameters);
        return parameters;
    }

    @Bean
    public ClaimPathSettings claimPathSettings(Environment environment) {
        ClaimPathSettings parameter = SettingsFactory.claimPaths(environment);
        log.debug("Claim Paths: {}", (Object)parameter);
        return parameter;
    }
}

