package org.hglteam.platform.config.conditional;

import org.hglteam.platform.config.settings.SettingsFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Optional;
import java.util.function.Predicate;

public class DatabaseAvailable implements Condition {
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return Optional.of(SettingsFactory.APPLICATION_DATASOURCE_AVAILABLE)
                .map(context.getEnvironment()::getProperty)
                .filter(Predicate.not(String::isBlank))
                .map(Boolean::parseBoolean)
                .orElse(Boolean.FALSE);
    }
}
