package org.hglteam.platform.config.resource;

import org.hglteam.platform.resource.DataResourceReader;
import org.hglteam.platform.resource.DefaultDataResourceReader;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

import java.util.Optional;

public class DataResourceProtocolResolver implements ProtocolResolver {
    private final DataResourceReader dataResourceReader;

    public DataResourceProtocolResolver(DataResourceReader resourceReader) {
        this.dataResourceReader = resourceReader;
    }

    public DataResourceProtocolResolver() {
        this(new DefaultDataResourceReader());
    }

    @Override
    public Resource resolve(String location, ResourceLoader resourceLoader) {
        return Optional.of(location)
                .filter(value -> value.startsWith(DataResourceReader.PROTOCOL))
                .map(dataResourceReader::read)
                .map(InputStreamResource::new)
                .orElse(null);
    }
}
