/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.config.remote;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hglteam.config.remote.RemoteConfigObjectFactory;
import org.hglteam.config.remote.RemoteConfigRestServiceProperties;
import org.hglteam.config.remote.RemoteConfigServiceClient;
import org.hglteam.config.remote.RemotePropertySource;
import org.hglteam.config.remote.SerializableEnvironment;
import org.hglteam.config.remote.SerializablePropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class RemoteConfigRestClient
implements RemoteConfigServiceClient {
    private static final Logger log = LoggerFactory.getLogger(RemoteConfigRestClient.class);
    private final RestTemplate restTemplate;
    private final RemoteConfigRestServiceProperties properties;
    private final RemoteConfigObjectFactory remoteConfigObjectFactory;

    public RemoteConfigRestClient(RestTemplate restTemplate, RemoteConfigRestServiceProperties properties, RemoteConfigObjectFactory originTrackedObjectFactory) {
        this.restTemplate = restTemplate;
        this.properties = properties;
        this.remoteConfigObjectFactory = originTrackedObjectFactory;
    }

    public PropertySource<?> fetch(Environment environment) {
        RemotePropertySource remotePropertySource = this.remoteConfigObjectFactory.createRemotePropertySource("remoteConfig");
        if (this.properties.getLabels().length == 0) {
            throw new RemoteConfigServiceClient.RemoteConfigFetchException("No labels were provided.", (Throwable)new IllegalStateException());
        }
        for (String label : this.properties.getLabels()) {
            log.info("Fetching properties for label {}...", (Object)label);
            SerializableEnvironment remoteEnv = this.getRemoteEnvironment(label);
            if (Objects.nonNull(remoteEnv) && Objects.nonNull(remoteEnv.getPropertySources())) {
                Collection properties = remoteEnv.getPropertySources().stream().map(this::convertPropertySource).collect(Collectors.toList());
                properties.forEach(arg_0 -> ((RemotePropertySource)remotePropertySource).addPropertySource(arg_0));
                log.info("Registered {} properties from label {}", (Object)properties.size(), (Object)label);
                if (StringUtils.hasText((String)remoteEnv.getState()) || StringUtils.hasText((String)remoteEnv.getState())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    this.putValue(map, "config.client.state", remoteEnv.getState());
                    this.putValue(map, "config.client.version", remoteEnv.getVersion());
                    remotePropertySource.addFirstPropertySource((PropertySource)new MapPropertySource("remoteConfig", map));
                }
                return remotePropertySource;
            }
            log.debug("No configuration found for label {}... Skip.", (Object)label);
        }
        throw new RemoteConfigServiceClient.RemoteConfigFetchException("Could not locate remote config.", (Throwable)new IllegalStateException());
    }

    private void putValue(HashMap<String, Object> map, String key, String value) {
        if (StringUtils.hasText((String)value)) {
            map.put(key, value);
        }
    }

    private PropertySource<?> convertPropertySource(SerializablePropertySource source) {
        HashMap properties = new HashMap();
        for (Map.Entry entry : source.getSource().entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                value = this.remoteConfigObjectFactory.createPropertyValue(source.getName(), valueMap.get("origin"), valueMap.get("value"));
            }
            properties.put(key, value);
        }
        return this.remoteConfigObjectFactory.createPropertySource(source.getName(), properties);
    }

    private SerializableEnvironment getRemoteEnvironment(String label) {
        String path = "/{name}/{profile}" + (StringUtils.hasText((String)label) ? "/{label}" : "");
        String normalizedLabel = RemoteConfigServiceClient.normalizeLabel((String)label);
        Object[] args = (String[])Stream.of(this.properties.getName(), this.properties.getProfile(), normalizedLabel).filter(StringUtils::hasText).toArray(String[]::new);
        Object lastException = null;
        ResponseEntity response = null;
        if (this.properties.getBaseUris().length == 0) {
            lastException = new RemoteConfigServiceClient.RemoteConfigFetchException("No remote server URI's were provided.", (Throwable)new IllegalStateException());
        }
        for (String uri : this.properties.getBaseUris()) {
            try {
                HttpEntity noEntity = new HttpEntity((Object)null);
                response = this.restTemplate.exchange(uri + path, HttpMethod.GET, noEntity, SerializableEnvironment.class, args);
                if (!Optional.ofNullable(response).map(ResponseEntity::getStatusCode).map(arg_0 -> HttpStatus.OK.equals(arg_0)).orElse(Boolean.FALSE).booleanValue()) continue;
                break;
            }
            catch (HttpClientErrorException e) {
                log.debug(String.format("Http Error fetching configuration from '%s':", uri + path), (Throwable)e);
                if (e.getStatusCode() == HttpStatus.NOT_FOUND) continue;
                lastException = e;
            }
            catch (Exception e) {
                log.debug(String.format("Error fetching configuration from '%s':", uri + path), (Throwable)e);
                lastException = e;
            }
        }
        return Optional.ofNullable(response).filter(r -> r.getStatusCode() == HttpStatus.OK).map(HttpEntity::getBody).orElseGet(RemoteConfigServiceClient.RemoteConfigFetchException.optionalErrorCausedBy((String)String.format("Could not fetch config of label '%s'", label), (Throwable)lastException));
    }
}

