/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.config.remote;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Optional;
import org.hglteam.config.remote.OriginTrackedPojoFactory;
import org.hglteam.config.remote.RemoteConfigObjectFactory;
import org.hglteam.config.remote.RemoteConfigRestClient;
import org.hglteam.config.remote.RemoteConfigRestServiceProperties;
import org.hglteam.config.remote.RemoteConfigServiceClient;
import org.hglteam.config.remote.RemoteConfigServiceProperties;
import org.hglteam.config.remote.condition.NoRemoteConfigObjectFactoryDefined;
import org.hglteam.config.remote.condition.NoRemoteConfigRestTemplateDefined;
import org.hglteam.config.remote.condition.NoRemoteConfigServiceClientDefined;
import org.hglteam.config.remote.condition.NoRemoteConfigServicePropertiesDefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration
@Deprecated
public class RemoteConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RemoteConfiguration.class);

    @Bean
    @Conditional(value={NoRemoteConfigServicePropertiesDefined.class})
    public static RemoteConfigRestServiceProperties remoteConfigRestServiceProperties(Environment environment) {
        return ((RemoteConfigRestServiceProperties.RemoteConfigRestServicePropertiesBuilder)((RemoteConfigRestServiceProperties.RemoteConfigRestServicePropertiesBuilder)((RemoteConfigRestServiceProperties.RemoteConfigRestServicePropertiesBuilder)((RemoteConfigRestServiceProperties.RemoteConfigRestServicePropertiesBuilder)((RemoteConfigRestServiceProperties.RemoteConfigRestServicePropertiesBuilder)((RemoteConfigRestServiceProperties.RemoteConfigRestServicePropertiesBuilder)RemoteConfigRestServiceProperties.builder().baseUris(RemoteConfiguration.splitLabelsOrEmpty(environment.getProperty("config.remote.url"))).name(environment.getProperty("config.remote.name"))).profile(environment.getProperty("config.remote.profile"))).labels(RemoteConfiguration.splitLabelsOrEmpty(environment.getProperty("config.remote.label")))).retry(Boolean.TRUE.equals(environment.getProperty("config.remote.retry", Boolean.class)))).readTimeout((Integer)environment.getProperty("config.remote.read-timeout", Integer.class, (Object)1000))).connectTimeout((Integer)environment.getProperty("config.remote.connect-timeout", Integer.class, (Object)1000))).build();
    }

    @Bean(value={"remoteConfigRestTemplate"})
    @Conditional(value={NoRemoteConfigRestTemplateDefined.class})
    public static RestTemplate restTemplate(RemoteConfigServiceProperties properties) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (properties.getReadTimeout() < 0) {
            throw new IllegalStateException("Invalid Value for Read Timeout set.");
        }
        if (properties.getConnectTimeout() < 0) {
            throw new IllegalStateException("Invalid Value for Connect Timeout set.");
        }
        requestFactory.setReadTimeout(properties.getReadTimeout());
        requestFactory.setConnectTimeout(properties.getConnectTimeout());
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        template.setMessageConverters(Arrays.asList(new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(), new FormHttpMessageConverter(), new GsonHttpMessageConverter(new Gson()), new ResourceHttpMessageConverter()));
        return template;
    }

    @Bean
    @Conditional(value={NoRemoteConfigObjectFactoryDefined.class})
    public static RemoteConfigObjectFactory remoteConfigObjectFactory() {
        return new OriginTrackedPojoFactory();
    }

    @Bean
    @Conditional(value={NoRemoteConfigServiceClientDefined.class})
    public static RemoteConfigRestClient remoteConfigRestClient(RemoteConfigRestServiceProperties properties, @Qualifier(value="remoteConfigRestTemplate") RestTemplate restTemplate, RemoteConfigObjectFactory remoteConfigObjectFactory) {
        return new RemoteConfigRestClient(restTemplate, properties, remoteConfigObjectFactory);
    }

    @Bean
    @Order(value=0)
    public static PropertySourcesPlaceholderConfigurer remotePropertySource(ConfigurableApplicationContext configurableContext, RemoteConfigServiceClient client) {
        PropertySource propertySource;
        PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
        MutablePropertySources sources = new MutablePropertySources();
        if (configurableContext.containsBean("remoteConfigRetryTemplate")) {
            RetryTemplate retryTemplate = (RetryTemplate)configurableContext.getBean("remoteConfigRetryTemplate", RetryTemplate.class);
            propertySource = (PropertySource)retryTemplate.execute(retryContext -> RemoteConfiguration.delegateFetch(retryContext, (Environment)configurableContext.getEnvironment(), client));
        } else {
            propertySource = client.fetch((Environment)configurableContext.getEnvironment());
        }
        sources.addLast(propertySource);
        configurableContext.getEnvironment().getPropertySources().addLast(propertySource);
        configurer.setPropertySources((PropertySources)sources);
        configurer.setIgnoreUnresolvablePlaceholders(true);
        configurer.setIgnoreResourceNotFound(true);
        return configurer;
    }

    private static String[] splitLabelsOrEmpty(String property) {
        return Optional.ofNullable(property).map(s -> s.split(",")).orElse(new String[0]);
    }

    private static PropertySource<?> delegateFetch(RetryContext context, Environment environment, RemoteConfigServiceClient client) {
        if (context.getRetryCount() > 0) {
            log.info("Retrying configuration fetch. Attempt {}", (Object)context.getRetryCount());
        }
        return client.fetch(environment);
    }
}

