/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.config.remote;

import java.util.Optional;
import org.hglteam.config.remote.OriginTrackedPojoFactory;
import org.hglteam.config.remote.RemoteConfigObjectFactory;
import org.hglteam.config.remote.RemoteConfigServiceClient;
import org.hglteam.config.remote.RemoteConfigServiceProperties;
import org.hglteam.config.remote.RemoteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;

public abstract class RemoteConfigurationInitializerBase<TClient extends RemoteConfigServiceClient, TProperties extends RemoteConfigServiceProperties, TPropertyBuilder extends RemoteConfigServiceProperties.RemoteConfigServicePropertiesBuilder<? extends TProperties, ?>>
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(RemoteConfiguration.class);
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final String CONFIG_REMOTE_RETRY_TEMPLATE_INITIAL_INTERVAL = "config.remote.retry-template.initial-interval";
    private static final String CONFIG_REMOTE_RETRY_TEMPLATE_MAX_INTERVAL = "config.remote.retry-template.max-interval";
    private static final String CONFIG_REMOTE_RETRY_TEMPLATE_MULTIPLIER = "config.remote.retry-template.multiplier";
    private static final String CONFIG_REMOTE_RETRY_TEMPLATE_MAX_ATTEMPS = "config.remote.retry-template.max-attemps";
    private static final String CONFIG_REMOTE_NAME = "config.remote.name";
    private static final String CONFIG_REMOTE_PROFILE = "config.remote.profile";
    private static final String CONFIG_REMOTE_LABEL = "config.remote.label";
    private static final String CONFIG_REMOTE_RETRY = "config.remote.retry";
    private static final String CONFIG_REMOTE_READ_TIMEOUT = "config.remote.read-timeout";
    private static final String CONFIG_REMOTE_CONNECT_TIMEOUT = "config.remote.connect-timeout";
    private static final String URL_SEPARATOR = " ";

    public void initialize(ConfigurableApplicationContext context) {
        RemoteConfigObjectFactory objectFactory = this.createRemoteConfigObjectFactory();
        RetryTemplate retryTemplate = this.createRetryTemplate((Environment)context.getEnvironment());
        TProperties serviceProperties = this.getRemoteConfigServiceProperties((Environment)context.getEnvironment());
        Object remoteConfigServiceClient = this.createRemoteConfigServiceClient(serviceProperties, objectFactory);
        PropertySource propertySource = (PropertySource)retryTemplate.execute(retryContext -> RemoteConfigurationInitializerBase.delegateFetch(retryContext, (Environment)context.getEnvironment(), remoteConfigServiceClient));
        context.getEnvironment().getPropertySources().addLast(propertySource);
    }

    protected RetryTemplate createRetryTemplate(Environment e) {
        int initialInterval = (Integer)e.getProperty(CONFIG_REMOTE_RETRY_TEMPLATE_INITIAL_INTERVAL, Integer.class, (Object)1000);
        int maxInterval = (Integer)e.getProperty(CONFIG_REMOTE_RETRY_TEMPLATE_MAX_INTERVAL, Integer.class, (Object)10000);
        double multiplier = (Double)e.getProperty(CONFIG_REMOTE_RETRY_TEMPLATE_MULTIPLIER, Double.class, (Object)1.6);
        int attempts = (Integer)e.getProperty(CONFIG_REMOTE_RETRY_TEMPLATE_MAX_ATTEMPS, Integer.class, (Object)5);
        return RetryTemplate.builder().exponentialBackoff((long)initialInterval, multiplier, (long)maxInterval).maxAttempts(attempts).build();
    }

    protected abstract TPropertyBuilder getRemoteConfigClientPropertyBuilder(Environment var1);

    protected abstract TClient createRemoteConfigServiceClient(TProperties var1, RemoteConfigObjectFactory var2);

    private TProperties getRemoteConfigServiceProperties(Environment environment) {
        return (TProperties)this.getRemoteConfigClientPropertyBuilder(environment).name(environment.getProperty(CONFIG_REMOTE_NAME)).profile(environment.getProperty(CONFIG_REMOTE_PROFILE)).labels(RemoteConfigurationInitializerBase.splitLabelsOrEmpty(environment.getProperty(CONFIG_REMOTE_LABEL))).retry(Boolean.TRUE.equals(environment.getProperty(CONFIG_REMOTE_RETRY, Boolean.class))).readTimeout(((Integer)environment.getProperty(CONFIG_REMOTE_READ_TIMEOUT, Integer.class, (Object)1000)).intValue()).connectTimeout(((Integer)environment.getProperty(CONFIG_REMOTE_CONNECT_TIMEOUT, Integer.class, (Object)1000)).intValue()).build();
    }

    protected RemoteConfigObjectFactory createRemoteConfigObjectFactory() {
        return new OriginTrackedPojoFactory();
    }

    protected static String[] splitLabelsOrEmpty(String property) {
        return Optional.ofNullable(property).map(s -> s.split(URL_SEPARATOR)).orElse(EMPTY_ARRAY);
    }

    private static PropertySource<?> delegateFetch(RetryContext context, Environment environment, RemoteConfigServiceClient client) {
        if (context.getRetryCount() > 0) {
            log.info("Retrying remote configuration. Attempt {}", (Object)context.getRetryCount());
        }
        return client.fetch(environment);
    }
}

