/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.testing.jpatesting.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hglteam.testing.jpatesting.DatasourceProvider;
import org.hglteam.testing.jpatesting.JpaConfigurer;
import org.hglteam.testing.jpatesting.core.BasicPersistenceUnitInfo;
import org.hglteam.testing.jpatesting.core.JpaPropertyConfigurerBase;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public abstract class JpaConfigurerBase<E extends JpaConfigurerBase<E, ?>, PC extends JpaPropertyConfigurerBase<?, E>>
implements JpaConfigurer<E, PC> {
    private static final String DEFAULT_PERSISTENCE_PROVIDER_CLASS_NAME = "org.hibernate.jpa.HibernatePersistenceProvider";
    private String persistenceUnitName;
    private DatasourceProvider provider;
    private String persistenceProviderClassName = "org.hibernate.jpa.HibernatePersistenceProvider";
    private List<String> classNames = new ArrayList<String>();
    private List<String> mappingFiles = new ArrayList<String>();
    private PC propertyConfigurer;

    protected JpaConfigurerBase() {
        this.provider = this::getDatasource;
    }

    public E persistenceUnitName(String name) {
        this.persistenceUnitName = name;
        return this.self();
    }

    public E persistenceProviderClassName(String className) {
        this.persistenceProviderClassName = className;
        return this.self();
    }

    public E datasourceProvider(DatasourceProvider provider) {
        this.provider = provider;
        return this.self();
    }

    public E withEntity(String entityClassName) {
        this.classNames.add(entityClassName);
        return this.self();
    }

    public E withEntities(String ... entityClassNames) {
        this.classNames.addAll(Arrays.asList(entityClassNames));
        return this.self();
    }

    public E withEntity(Class<?> entityClass) {
        return (E)this.withEntity(entityClass.getName());
    }

    public E withEntities(Class<?> ... entityClasses) {
        return (E)this.withEntities((String[])Stream.of(entityClasses).map(Class::getName).toArray(String[]::new));
    }

    public E withMapping(String url) {
        this.mappingFiles.add(url);
        return this.self();
    }

    public E withMappings(String ... urls) {
        this.mappingFiles.addAll(Arrays.asList(urls));
        return this.self();
    }

    public PC properties() {
        this.propertyConfigurer = this.createProperties();
        return this.propertyConfigurer;
    }

    public EntityManagerFactory buildFactory() {
        Object info = ((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)((BasicPersistenceUnitInfo.BasicPersistenceUnitInfoBuilder)BasicPersistenceUnitInfo.builder().persistenceUnitName(this.persistenceUnitName)).managedClassNames(this.classNames)).mappingFileNames(this.mappingFiles)).properties(((JpaPropertyConfigurerBase)this.propertyConfigurer).toProperties())).nonJtaDataSource((DataSource)this.provider.get())).transactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL)).sharedCacheMode(SharedCacheMode.UNSPECIFIED)).validationMode(ValidationMode.AUTO)).persistenceProviderClassName(this.persistenceProviderClassName)).build();
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor(info), new HashMap()).build();
    }

    protected PC getPropertyConfigurer() {
        return this.propertyConfigurer;
    }

    protected abstract DataSource getDatasource();

    protected abstract PC createProperties();

    protected abstract E self();
}

