/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.testing.jpatesting.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.hglteam.testing.jpatesting.JpaPropertyConfigurer;
import org.hglteam.testing.jpatesting.core.JpaConfigurerBase;

public abstract class JpaPropertyConfigurerBase<PC extends JpaPropertyConfigurerBase<PC, ?>, C extends JpaConfigurerBase<?, PC>>
implements JpaPropertyConfigurer<PC, C> {
    private final C configurer;
    private final Map<String, Object> propertyMap = new HashMap<String, Object>();

    protected JpaPropertyConfigurerBase(C configurer) {
        this.configurer = configurer;
    }

    public PC driver(String driverClassName) {
        return (PC)this.put("javax.persistence.jdbc.driver", driverClassName);
    }

    public PC driver(Class<?> driverClassName) {
        return (PC)this.driver(driverClassName.getName());
    }

    public PC url(String url) {
        return (PC)this.put("javax.persistence.jdbc.url", url);
    }

    public PC username(String username) {
        return (PC)this.put("javax.persistence.jdbc.user", username);
    }

    public PC password(String password) {
        return (PC)this.put("javax.persistence.jdbc.password", password);
    }

    public PC lockTimeout(Long value) {
        return (PC)this.put("javax.persistence.lock.timeout", value);
    }

    public PC queryTimeout(Long value) {
        return (PC)this.put("javax.persistence.query.timeout", value);
    }

    public PC createScriptSource(String url) {
        return (PC)this.put("javax.persistence.schema-generation.create-script-source", url);
    }

    public PC dropScriptSource(String url) {
        return (PC)this.put("javax.persistence.schema-generation.drop-script-source", url);
    }

    public PC sqlLoadScriptSource(String url) {
        return (PC)this.put("javax.persistence.sql-load-script-source", url);
    }

    public PC schemaGenerationDatabaseAction(JpaPropertyConfigurer.DatabaseAction action) {
        return (PC)this.put("javax.persistence.schema-generation.database.action", action.getValue());
    }

    public PC schemaGenerationScriptsAction(JpaPropertyConfigurer.ScriptAction scriptAction) {
        return (PC)this.put("javax.persistence.schema-generation.scripts.action", scriptAction.getValue());
    }

    public PC schemaGenerationCreateSource(JpaPropertyConfigurer.GenerationSource source) {
        return (PC)this.put("javax.persistence.schema-generation.create-source", source.getValue());
    }

    public PC schemaGenerationDropSource(JpaPropertyConfigurer.GenerationSource source) {
        return (PC)this.put("javax.persistence.schema-generation.drop-source", source.getValue());
    }

    public PC schemaGenerationCreateScriptTarget(String url) {
        return (PC)this.put("javax.persistence.schema-generation.scripts.create-target", url);
    }

    public PC schemaGenerationDropScriptTarget(String url) {
        return (PC)this.put("javax.persistence.schema-generation.scripts.drop-target", url);
    }

    public C and() {
        return this.configurer;
    }

    public Map<String, Object> toMap() {
        return Map.copyOf(this.propertyMap);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.propertyMap);
        return properties;
    }

    public PC put(String property, Object value) {
        this.propertyMap.put(property, value);
        return this.self();
    }

    public <T> T get(String property, T defaultValue, Function<Object, T> converterFunction) {
        return Optional.of(property).map(this.propertyMap::get).map(converterFunction).orElse(defaultValue);
    }

    public <T> T get(String property, Function<Object, T> converterFunction) {
        return Optional.of(property).map(this.propertyMap::get).map(converterFunction).orElse(null);
    }

    protected abstract PC self();
}

