/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.validation.reactive;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hglteam.validation.reactive.ExceptionProvider;
import org.hglteam.validation.reactive.MultiStepValidation;
import org.hglteam.validation.reactive.ReactivePredicate;
import org.hglteam.validation.reactive.SimpleValidation;
import org.hglteam.validation.reactive.Validation;
import org.hglteam.validation.reactive.Validations;
import reactor.core.publisher.Mono;

public abstract class MultiStepValidationBuilderBase<T, B extends MultiStepValidationBuilderBase<T, B>> {
    private Validation<T> finalValidation = Mono::just;

    protected MultiStepValidationBuilderBase() {
    }

    public ValidationStepBuilder when(ReactivePredicate<T> predicate) {
        return new ValidationStepBuilder(predicate);
    }

    public ValidationStepBuilder whenValue(Predicate<T> predicate) {
        return this.when(ReactivePredicate.of(predicate));
    }

    public <U> B onProperty(Function<T, U> getter, Consumer<MultiStepValidation<U>> validator) {
        MultiStepValidation propertyValidator = Validations.builder();
        validator.accept(propertyValidator);
        return this.thenCheck(source -> Mono.just((Object)source).map(getter).flatMap(propertyValidator::validate).then(Mono.just((Object)source)));
    }

    protected Validation<T> getFinalValidation() {
        return this.finalValidation;
    }

    protected abstract B self();

    public B thenCheck(Validation<T> validation) {
        this.finalValidation = this.finalValidation.then(validation);
        return this.self();
    }

    public class ValidationStepBuilder {
        public ReactivePredicate<T> predicate;

        public ValidationStepBuilder(ReactivePredicate<T> predicate) {
            this.predicate = predicate;
        }

        public ValidationStepBuilder and(ReactivePredicate<T> other) {
            this.predicate = this.predicate.and(other);
            return this;
        }

        public ValidationStepBuilder andValue(Predicate<T> other) {
            return this.and(ReactivePredicate.of(other));
        }

        public ValidationStepBuilder or(ReactivePredicate<T> other) {
            this.predicate = this.predicate.or(other);
            return this;
        }

        public ValidationStepBuilder orValue(Predicate<T> other) {
            return this.or(ReactivePredicate.of(other));
        }

        public B then(ExceptionProvider<T, ?> exceptionProvider) {
            return MultiStepValidationBuilderBase.this.thenCheck(((SimpleValidation.SimpleValidationBuilder)((SimpleValidation.SimpleValidationBuilder)SimpleValidation.builder().predicate(this.predicate)).exceptionProvider(exceptionProvider)).build());
        }
    }
}

