/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.validation.reactive;

import org.hglteam.validation.reactive.ExceptionProvider;
import org.hglteam.validation.reactive.ReactivePredicate;
import org.hglteam.validation.reactive.Validation;
import reactor.core.publisher.Mono;

public class SimpleValidation<T>
implements Validation<T> {
    private final ReactivePredicate<T> predicate;
    private final ExceptionProvider<T, ?> exceptionProvider;

    @Override
    public Mono<T> validate(T source) {
        return this.predicate.test(source).flatMap(result -> result != false ? Mono.error(this.exceptionProvider.create(source)) : Mono.just((Object)source));
    }

    protected SimpleValidation(SimpleValidationBuilder<T, ?, ?> b) {
        this.predicate = b.predicate;
        this.exceptionProvider = b.exceptionProvider;
    }

    public static <T> SimpleValidationBuilder<T, ?, ?> builder() {
        return new SimpleValidationBuilderImpl();
    }

    public SimpleValidationBuilder<T, ?, ?> toBuilder() {
        return new SimpleValidationBuilderImpl().$fillValuesFrom(this);
    }

    public ReactivePredicate<T> getPredicate() {
        return this.predicate;
    }

    public ExceptionProvider<T, ?> getExceptionProvider() {
        return this.exceptionProvider;
    }

    public static abstract class SimpleValidationBuilder<T, C extends SimpleValidation<T>, B extends SimpleValidationBuilder<T, C, B>> {
        private ReactivePredicate<T> predicate;
        private ExceptionProvider<T, ?> exceptionProvider;

        protected B $fillValuesFrom(C instance) {
            SimpleValidationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(SimpleValidation<T> instance, SimpleValidationBuilder<T, ?, ?> b) {
            b.predicate(instance.predicate);
            b.exceptionProvider(instance.exceptionProvider);
        }

        public B predicate(ReactivePredicate<T> predicate) {
            this.predicate = predicate;
            return this.self();
        }

        public B exceptionProvider(ExceptionProvider<T, ?> exceptionProvider) {
            this.exceptionProvider = exceptionProvider;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "SimpleValidation.SimpleValidationBuilder(predicate=" + this.predicate + ", exceptionProvider=" + this.exceptionProvider + ")";
        }
    }

    private static final class SimpleValidationBuilderImpl<T>
    extends SimpleValidationBuilder<T, SimpleValidation<T>, SimpleValidationBuilderImpl<T>> {
        private SimpleValidationBuilderImpl() {
        }

        @Override
        protected SimpleValidationBuilderImpl<T> self() {
            return this;
        }

        @Override
        public SimpleValidation<T> build() {
            return new SimpleValidation(this);
        }
    }
}

