/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.validation.reactive;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hglteam.validation.reactive.ExceptionProvider;

public final class ValidationError
extends IllegalArgumentException {
    private ValidationError() {
    }

    public static <T extends RuntimeException> ValidationErrorBuilder<T> using(Function<String, T> exceptionConstructor) {
        return new ValidationErrorBuilder<T>(exceptionConstructor);
    }

    public static <X, T extends RuntimeException> ExceptionProvider<X, T> from(Supplier<T> exceptionConstructor) {
        return x -> (RuntimeException)exceptionConstructor.get();
    }

    public static <X, T extends RuntimeException> ExceptionProvider<X, T> withMessage(Function<String, T> constructor, String message, Object ... args) {
        return ValidationError.using(constructor).message(message).andArguments(args);
    }

    public static class ValidationErrorBuilder<T extends RuntimeException> {
        private final Function<String, T> constructor;
        private String message;

        public ValidationErrorBuilder(Function<String, T> constructor) {
            this.constructor = constructor;
        }

        public ValidationErrorBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public <X> ExceptionProvider<X, T> andNoArguments() {
            return this.andArguments(new Object[0]);
        }

        public <X> ExceptionProvider<X, T> andArguments(Object ... args) {
            return this.andArguments((X x) -> args);
        }

        public <X> ExceptionProvider<X, T> andArguments(Function<X, Object[]> argumentExtractor) {
            return x -> this.create(this.message, (Object[])argumentExtractor.apply(x));
        }

        private T create(String message, Object[] args) {
            return (T)(Objects.nonNull(message) ? (RuntimeException)this.constructor.apply(MessageFormat.format(message, args)) : (RuntimeException)this.constructor.apply(null));
        }
    }
}

