/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hglteam.validation.MultistepValidationBuilder;
import org.hglteam.validation.SimpleValidation;
import org.hglteam.validation.Validation;
import org.hglteam.validation.ValidationException;

public abstract class MultistepValidationBuilderBase<T, B extends MultistepValidationBuilderBase<T, B>> {
    protected final List<Validation<T>> validations = new ArrayList<Validation<T>>();

    protected MultistepValidationBuilderBase() {
    }

    public ValidationStepBuilder when(Predicate<T> predicate) {
        return new ValidationStepBuilder(predicate);
    }

    public <P> B onProperty(Function<T, P> getter, Consumer<MultistepValidationBuilderBase<P, ?>> builderConfigurator) {
        this.validations.add(this.propertyValidator(getter, builderConfigurator));
        return this.self();
    }

    protected <P> Validation<T> propertyValidator(Function<T, P> getter, Consumer<MultistepValidationBuilderBase<P, ?>> builderConfigurator) {
        return t -> {
            Object value = getter.apply(t);
            MultistepValidationBuilder builder = Validation.builder();
            builderConfigurator.accept(builder);
            builder.validate(value);
        };
    }

    protected abstract B self();

    public class ValidationStepBuilder {
        private Predicate<T> predicate;

        private ValidationStepBuilder(Predicate<T> condition) {
            this.predicate = condition;
        }

        public ValidationStepBuilder and(Predicate<T> condition) {
            this.predicate = this.predicate.and(condition);
            return this;
        }

        public ValidationStepBuilder or(Predicate<T> condition) {
            this.predicate = this.predicate.or(condition);
            return this;
        }

        public B then(Function<T, ValidationException> exceptionFunction) {
            MultistepValidationBuilderBase.this.validations.add(((SimpleValidation.SimpleValidationBuilder)((SimpleValidation.SimpleValidationBuilder)SimpleValidation.builder().predicate(this.predicate)).exceptionFunction(exceptionFunction)).build());
            return MultistepValidationBuilderBase.this.self();
        }
    }
}

