/*
 * Decompiled with CFR 0.152.
 */
package org.hglteam.validation;

import java.util.function.Function;
import java.util.function.Predicate;
import org.hglteam.validation.Validation;
import org.hglteam.validation.ValidationException;

public class SimpleValidation<T>
implements Validation<T> {
    private final Predicate<T> predicate;
    private final Function<T, ValidationException> exceptionFunction;

    @Override
    public void validate(T target) {
        if (this.predicate.test(target)) {
            throw this.exceptionFunction.apply(target);
        }
    }

    protected SimpleValidation(SimpleValidationBuilder<T, ?, ?> b) {
        this.predicate = b.predicate;
        this.exceptionFunction = b.exceptionFunction;
    }

    public static <T> SimpleValidationBuilder<T, ?, ?> builder() {
        return new SimpleValidationBuilderImpl();
    }

    public SimpleValidationBuilder<T, ?, ?> toBuilder() {
        return new SimpleValidationBuilderImpl().$fillValuesFrom(this);
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public Function<T, ValidationException> getExceptionFunction() {
        return this.exceptionFunction;
    }

    private static final class SimpleValidationBuilderImpl<T>
    extends SimpleValidationBuilder<T, SimpleValidation<T>, SimpleValidationBuilderImpl<T>> {
        private SimpleValidationBuilderImpl() {
        }

        @Override
        protected SimpleValidationBuilderImpl<T> self() {
            return this;
        }

        @Override
        public SimpleValidation<T> build() {
            return new SimpleValidation(this);
        }
    }

    public static abstract class SimpleValidationBuilder<T, C extends SimpleValidation<T>, B extends SimpleValidationBuilder<T, C, B>> {
        private Predicate<T> predicate;
        private Function<T, ValidationException> exceptionFunction;

        protected B $fillValuesFrom(C instance) {
            SimpleValidationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(SimpleValidation<T> instance, SimpleValidationBuilder<T, ?, ?> b) {
            b.predicate(instance.predicate);
            b.exceptionFunction(instance.exceptionFunction);
        }

        protected abstract B self();

        public abstract C build();

        public B predicate(Predicate<T> predicate) {
            this.predicate = predicate;
            return this.self();
        }

        public B exceptionFunction(Function<T, ValidationException> exceptionFunction) {
            this.exceptionFunction = exceptionFunction;
            return this.self();
        }

        public String toString() {
            return "SimpleValidation.SimpleValidationBuilder(predicate=" + this.predicate + ", exceptionFunction=" + this.exceptionFunction + ")";
        }
    }
}

