/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.converter.spi;

import org.hibernate.search.engine.backend.document.converter.ToIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.runtime.ToIndexFieldValueConvertContext;
import org.hibernate.search.util.impl.common.Contracts;

public final class PassThroughToIndexFieldValueConverter<F>
implements ToIndexFieldValueConverter<F, F> {
    private final Class<F> valueType;

    public PassThroughToIndexFieldValueConverter(Class<F> valueType) {
        Contracts.assertNotNull(valueType, (String)"valueType");
        this.valueType = valueType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.valueType + "]";
    }

    @Override
    public F convert(F value, ToIndexFieldValueConvertContext context) {
        return value;
    }

    @Override
    public F convertUnknown(Object value, ToIndexFieldValueConvertContext context) {
        return this.valueType.cast(value);
    }

    @Override
    public boolean isCompatibleWith(ToIndexFieldValueConverter<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        PassThroughToIndexFieldValueConverter castedOther = (PassThroughToIndexFieldValueConverter)other;
        return this.valueType.equals(castedOther.valueType);
    }
}

