/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldContext;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaObjectField;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaObjectFieldImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.StringHelper;

public class IndexSchemaElementImpl<B extends IndexSchemaObjectNodeBuilder>
implements IndexSchemaElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final B objectNodeBuilder;
    private final IndexSchemaNestingContext nestingContext;

    public IndexSchemaElementImpl(B objectNodeBuilder, IndexSchemaNestingContext nestingContext) {
        this.objectNodeBuilder = objectNodeBuilder;
        this.nestingContext = nestingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "objectNodeBuilder=" + this.objectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public IndexSchemaFieldContext field(String relativeFieldName) {
        this.checkRelativeFieldName(relativeFieldName);
        return this.nestingContext.nest(relativeFieldName, arg_0 -> this.objectNodeBuilder.addField(arg_0), arg_0 -> this.objectNodeBuilder.createExcludedField(arg_0));
    }

    @Override
    public IndexSchemaObjectField objectField(String relativeFieldName, ObjectFieldStorage storage) {
        this.checkRelativeFieldName(relativeFieldName);
        return this.nestingContext.nest(relativeFieldName, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.addObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(objectFieldBuilder, (IndexSchemaNestingContext)filter);
        }, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.createExcludedObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(objectFieldBuilder, (IndexSchemaNestingContext)filter);
        });
    }

    private void checkRelativeFieldName(String relativeFieldName) {
        if (StringHelper.isEmpty((String)relativeFieldName)) {
            throw log.relativeFieldNameCannotBeNullOrEmpty(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
        if (relativeFieldName.contains(".")) {
            throw log.relativeFieldNameCannotContainDot(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
    }
}

