/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.backend.document.converter.FromIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.ToIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.spi.PassThroughToIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.DeferredInitializationIndexFieldAccessor;
import org.hibernate.search.engine.backend.document.spi.UserIndexFieldConverter;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.Contracts;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class IndexSchemaFieldDefinitionHelper<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSchemaContext schemaContext;
    private final DeferredInitializationIndexFieldAccessor<F> deferredInitializationAccessor = new DeferredInitializationIndexFieldAccessor();
    private final Class<F> indexFieldType;
    private ToIndexFieldValueConverter<?, ? extends F> dslToIndexConverter;
    private FromIndexFieldValueConverter<? super F, ?> indexToProjectionConverter;
    private boolean accessorCreated = false;

    public IndexSchemaFieldDefinitionHelper(IndexSchemaContext schemaContext, Class<F> indexFieldType) {
        this(schemaContext, indexFieldType, new PassThroughToIndexFieldValueConverter<F>(indexFieldType));
    }

    public IndexSchemaFieldDefinitionHelper(IndexSchemaContext schemaContext, Class<F> indexFieldType, ToIndexFieldValueConverter<F, ? extends F> identityToIndexConverter) {
        this.schemaContext = schemaContext;
        this.indexFieldType = indexFieldType;
        this.dslToIndexConverter = identityToIndexConverter;
        this.indexToProjectionConverter = null;
    }

    public IndexSchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public void dslConverter(ToIndexFieldValueConverter<?, ? extends F> toIndexConverter) {
        Contracts.assertNotNull(toIndexConverter, (String)"toIndexConverter");
        this.dslToIndexConverter = toIndexConverter;
    }

    public void projectionConverter(FromIndexFieldValueConverter<? super F, ?> fromIndexConverter) {
        Contracts.assertNotNull(fromIndexConverter, (String)"fromIndexConverter");
        this.indexToProjectionConverter = fromIndexConverter;
    }

    public IndexFieldAccessor<F> createAccessor() {
        if (this.accessorCreated) {
            throw log.cannotCreateAccessorMultipleTimes(this.schemaContext.getEventContext());
        }
        this.accessorCreated = true;
        return this.deferredInitializationAccessor;
    }

    public UserIndexFieldConverter<F> createUserIndexFieldConverter() {
        this.checkAccessorCreated();
        return new UserIndexFieldConverter<F>(this.indexFieldType, this.dslToIndexConverter, this.indexToProjectionConverter);
    }

    public void initialize(IndexFieldAccessor<F> delegate) {
        this.checkAccessorCreated();
        this.deferredInitializationAccessor.initialize(delegate);
    }

    private void checkAccessorCreated() {
        if (!this.accessorCreated) {
            throw log.incompleteFieldDefinition(this.schemaContext.getEventContext());
        }
    }
}

