/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.document.IndexObjectFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.spi.DeferredInitializationIndexObjectFieldAccessor;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class IndexSchemaObjectFieldDefinitionHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSchemaContext schemaContext;
    private final DeferredInitializationIndexObjectFieldAccessor rawAccessor = new DeferredInitializationIndexObjectFieldAccessor();
    private boolean accessorCreated = false;

    public IndexSchemaObjectFieldDefinitionHelper(IndexSchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    public IndexSchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public IndexObjectFieldAccessor createAccessor() {
        if (this.accessorCreated) {
            throw log.cannotCreateAccessorMultipleTimes(this.schemaContext.getEventContext());
        }
        this.accessorCreated = true;
        return this.rawAccessor;
    }

    public void initialize(IndexObjectFieldAccessor delegate) {
        if (!this.accessorCreated) {
            throw log.incompleteFieldDefinition(this.schemaContext.getEventContext());
        }
        this.rawAccessor.initialize(delegate);
    }
}

