/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.spi;

import org.hibernate.search.engine.backend.document.converter.FromIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.ToIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.runtime.FromIndexFieldValueConvertContext;
import org.hibernate.search.engine.backend.document.converter.runtime.ToIndexFieldValueConvertContext;

public final class UserIndexFieldConverter<F> {
    private final Class<F> indexFieldType;
    private final ToIndexFieldValueConverter<?, ? extends F> dslToIndexConverter;
    private final FromIndexFieldValueConverter<? super F, ?> indexToProjectionConverter;

    UserIndexFieldConverter(Class<F> indexFieldType, ToIndexFieldValueConverter<?, ? extends F> dslToIndexConverter, FromIndexFieldValueConverter<? super F, ?> indexToProjectionConverter) {
        this.indexFieldType = indexFieldType;
        this.dslToIndexConverter = dslToIndexConverter;
        this.indexToProjectionConverter = indexToProjectionConverter;
    }

    public String toString() {
        return this.getClass().getName() + "[dslToIndexConverter=" + this.dslToIndexConverter + ", indexToProjectionConverter=" + this.indexToProjectionConverter + "]";
    }

    public F convertDslToIndex(Object value, ToIndexFieldValueConvertContext context) {
        return this.dslToIndexConverter.convertUnknown(value, context);
    }

    public Object convertIndexToProjection(F indexValue, FromIndexFieldValueConvertContext context) {
        if (this.indexToProjectionConverter == null) {
            return indexValue;
        }
        return this.indexToProjectionConverter.convert(indexValue, context);
    }

    public boolean isConvertDslToIndexCompatibleWith(UserIndexFieldConverter<?> other) {
        if (other == null) {
            return false;
        }
        return this.dslToIndexConverter.isCompatibleWith(other.dslToIndexConverter);
    }

    public boolean isConvertIndexToProjectionCompatibleWith(UserIndexFieldConverter<?> other) {
        if (other == null) {
            return false;
        }
        if (this.indexToProjectionConverter == null || other.indexToProjectionConverter == null) {
            return this.indexToProjectionConverter == null && other.indexToProjectionConverter == null;
        }
        return this.indexToProjectionConverter.isCompatibleWith(other.indexToProjectionConverter);
    }

    public boolean isProjectionCompatibleWith(Class<?> projectionType) {
        if (this.indexToProjectionConverter == null) {
            return projectionType.isAssignableFrom(this.indexFieldType);
        }
        return this.indexToProjectionConverter.isConvertedTypeAssignableTo(projectionType);
    }
}

