/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class ConvertUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private ConvertUtils() {
    }

    public static <T> Optional<T> convert(Class<T> expectedType, Function<String, T> parser, Object value) {
        if (expectedType.isInstance(value)) {
            return Optional.of(expectedType.cast(value));
        }
        try {
            return ConvertUtils.optionalTrimmedNonEmpty((String)value).map(parser);
        }
        catch (RuntimeException e) {
            throw log.invalidPropertyValue(expectedType, e.getMessage(), e);
        }
    }

    public static Optional<Boolean> convertBoolean(Object value) {
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        try {
            Optional<String> optionalCleaned = ConvertUtils.optionalTrimmedNonEmpty((String)value);
            if (optionalCleaned.isPresent()) {
                String cleaned = optionalCleaned.get();
                if ("false".equalsIgnoreCase(cleaned)) {
                    return Optional.of(false);
                }
                if ("true".equalsIgnoreCase(cleaned)) {
                    return Optional.of(true);
                }
            }
        }
        catch (RuntimeException e) {
            throw log.invalidBooleanPropertyValue(e);
        }
        throw log.invalidBooleanPropertyValue(null);
    }

    public static Optional<Integer> convertInteger(Object value) {
        if (value instanceof Number) {
            return Optional.of(((Number)value).intValue());
        }
        try {
            return ConvertUtils.optionalTrimmedNonEmpty((String)value).map(Integer::parseInt);
        }
        catch (RuntimeException e) {
            throw log.invalidIntegerPropertyValue(e.getMessage(), e);
        }
    }

    public static Optional<Long> convertLong(Object value) {
        if (value instanceof Number) {
            return Optional.of(((Number)value).longValue());
        }
        try {
            return ConvertUtils.optionalTrimmedNonEmpty((String)value).map(Long::parseLong);
        }
        catch (RuntimeException e) {
            throw log.invalidLongPropertyValue(e.getMessage(), e);
        }
    }

    public static <T> Optional<List<T>> convertMultiValue(Pattern separatorPattern, Function<Object, Optional<T>> elementConverter, Object value) {
        if (value instanceof Collection) {
            List result = ((Collection)value).stream().map(elementConverter).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return Optional.of(result);
        }
        if (value instanceof String) {
            List result = ConvertUtils.optionalTrimmedNonEmpty((String)value).map(separatorPattern::splitAsStream).orElse(Stream.empty()).map(elementConverter).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return result.isEmpty() ? Optional.empty() : Optional.of(result);
        }
        throw log.invalidMultiPropertyValue();
    }

    private static Optional<String> optionalTrimmedNonEmpty(String value) {
        String trimmed;
        if (value != null && !value.isEmpty() && !(trimmed = value.trim()).isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

