/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

class FunctionConfigurationProperty<T>
implements ConfigurationProperty<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String key;
    private final Function<Optional<?>, T> function;

    FunctionConfigurationProperty(String key, Function<Optional<?>, T> function) {
        this.key = key;
        this.function = function;
    }

    @Override
    public T get(ConfigurationPropertySource source) {
        Optional<?> rawValue = source.get(this.key);
        try {
            return this.function.apply(rawValue);
        }
        catch (RuntimeException e) {
            String displayedKey = this.key;
            try {
                Optional<String> resolvedKey = source.resolve(this.key);
                if (resolvedKey.isPresent()) {
                    displayedKey = resolvedKey.get();
                }
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            throw log.unableToConvertConfigurationProperty(displayedKey, rawValue.isPresent() ? rawValue.get() : "", e.getMessage(), e);
        }
    }

    @Override
    public Optional<String> resolve(ConfigurationPropertySource source) {
        return source.resolve(this.key);
    }

    @Override
    public String resolveOrRaw(ConfigurationPropertySource source) {
        return this.resolve(source).orElse(this.key);
    }
}

