/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.util.impl.common.Contracts;

public class PrefixedConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource propertiesToPrefix;
    private final String radix;
    private final int radixLength;

    public PrefixedConfigurationPropertySource(ConfigurationPropertySource propertiesToPrefix, String prefix) {
        Contracts.assertNotNull((Object)propertiesToPrefix, (String)"propertiesToPrefix");
        Contracts.assertNotNull((Object)prefix, (String)"prefix");
        this.propertiesToPrefix = propertiesToPrefix;
        this.radix = prefix + ".";
        this.radixLength = this.radix.length();
    }

    @Override
    public Optional<?> get(String key) {
        if (key.startsWith(this.radix)) {
            return this.propertiesToPrefix.get(key.substring(this.radixLength));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> resolve(String key) {
        if (key.startsWith(this.radix)) {
            return this.propertiesToPrefix.resolve(key.substring(this.radixLength));
        }
        return Optional.empty();
    }

    @Override
    public ConfigurationPropertySource withPrefix(String prefix) {
        return new PrefixedConfigurationPropertySource(this.propertiesToPrefix, prefix + this.radix.substring(0, this.radix.length() - 1));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("prefix=").append(this.radix).append(", propertiesToPrefix=").append(this.propertiesToPrefix).append("]");
        return sb.toString();
    }
}

