/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;

public final class UnusedPropertyTrackingConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource delegate;
    private final Set<String> unusedPropertyKeys;

    public UnusedPropertyTrackingConfigurationPropertySource(ConfigurationPropertySource delegate, Set<String> availablePropertyKeys) {
        this.delegate = delegate;
        this.unusedPropertyKeys = ConcurrentHashMap.newKeySet();
        this.unusedPropertyKeys.addAll(availablePropertyKeys);
    }

    @Override
    public Optional<?> get(String key) {
        Optional<String> resolved = this.resolve(key);
        if (resolved.isPresent()) {
            this.unusedPropertyKeys.remove(resolved.get());
        }
        return this.delegate.get(key);
    }

    @Override
    public Optional<String> resolve(String key) {
        return this.delegate.resolve(key);
    }

    public Set<String> getUnusedPropertyKeys() {
        return Collections.unmodifiableSet(this.unusedPropertyKeys);
    }
}

